
local l = {}
aom_item_entity.eventbus_register = l

-- listen to an event, return `"_cancel"` to cancel the rest of the callbacks
function aom_item_entity.LISTEN(tag, callback)
    if l[tag] == nil then l[tag] = {} end
    table.insert(l[tag], callback)
end

-- signal an event, and cancel if returns `"_cancel"`
function aom_item_entity.SIGNAL(tag, ...)
    tag = l[tag]
    if not tag then return end
    for i, callback in ipairs(tag) do
        local val = callback(...)
        if val == "_cancel" then
            return "_cancel"
        end
    end
end

-- returns bool from all listeners, such that ==false forces false, and no true return is false
function aom_item_entity.CONDITIONAL(tag, ...)
    tag = l[tag]
    if not tag then return end
    local had_true = false
    for i, callback in ipairs(tag) do
        local val = callback(...)
        if val == "_cancel" then
            return had_true
        elseif val == true then
            had_true = true
        elseif val == false then
            return val
        end
    end
    return had_true
end
