


if aom_mob_spawn then
    aom_mob_spawn.register_mob({
        name = "aom_elementals:stone",
        groups = {"hostile", "aom_stone_elemental"},
        biomes = {},
        on_spawn = function(self, pos) end,
        can_spawn = function(pos, spawn_info)
            if math.random() > 0.001 and math.random() > 0.001 then return false end
            if not aom_dimensions.is_in("overworld", pos) then return false end
            if aom_mob_spawn.has_head_room(pos, 3)
            and aom_mob_spawn.has_light(pos, 12, 15) then
                if aom_entity_api.has_mobs_in_radius(pos, 100, {"aom_elementals:stone"}, 0, 0) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            local pos = self.object:get_pos()
            if not pos then return true end
            if not aom_entity_api.has_mobs_in_radius(pos, 100, {"aom_elementals:stone"}, 2, 2) then
                return true
            end
            if self._age and self._age < 300 then return false end
            return true
        end,
    })
    aom_mob_spawn.cap.aom_stone_elemental.max = 10

    aom_mob_spawn.register_mob({
        name = "aom_elementals:magma",
        groups = {"hostile", "aom_magma_elemental"},
        biomes = {},
        on_spawn = function(self, pos) end,
        can_spawn = function(pos, spawn_info)
            local below_node = minetest.get_node(vector.offset(pos, 0, -1, 0))
            if (below_node.name ~= "aom_underworld:lava_rock")
            and (below_node.name ~= "aom_underworld:lava_rock_coral") then return false end
            if not aom_mob_spawn.has_head_room(pos, 3) then return false end
            if not aom_entity_api.has_mobs_in_radius(pos, 50, {"aom_elementals:magma"}, 0, 2) then return false end
            return true
        end,
        can_despawn = function(self)
            if true then return true end
            if not aom_mob_spawn.has_player_in_range(self.object:get_pos(), 0, 30) then
                return true
            end
            if self._age and self._age < 10 then return false end
            local pos = self.object:get_pos()
            if not pos then
                return true
            end
            return true
        end,
    })
    aom_mob_spawn.cap.aom_magma_elemental.max = 20
end

