local S = core.get_translator(core.get_current_modname())

aom_compost = {}

-- dofile(mod_path .. "/api.lua")

local function get_random_time()
    return math.random(500,600)
end

local function on_timer(pos, time)
    local node = minetest.get_node(pos)
    if true then
        local i = minetest.get_item_group(node.name, "item_compost")
        minetest.swap_node(pos, {name="aom_compost:compost_"..(i)})
        minetest.get_node_timer(pos):start(get_random_time())
        return false
    else
        minetest.get_node_timer(pos):set(1,0)
    end
end

local function on_construct(pos)
    minetest.get_node_timer(pos):start(get_random_time())
end

local function _on_node_update(pos)
    local nt = minetest.get_node_timer(pos)
    if nt:is_started() then return false end
    nt:start(get_random_time())
end


local count = 3
for i = 0, count do
    local _tt_long_desc
    if i ~= count then
        _tt_long_desc = S("Slowly composts over time into nitrites.")
    end
    minetest.register_node('aom_compost:compost_'..i, {
        -- TL: compost node
        description = S("Compost"),
        _tt_long_desc = _tt_long_desc,
        groups = {
            full_solid = 1, nature = 1, item_compost = i+1, oddly_breakable_by_hand = 3,
            snappy = 1, solid = 1, suffocates = 2 },
        tiles = {"aom_compost_"..i..".png"},
        drop = (i == count) and {
            max_items = 40,
            items = {
                {
                    items = {'aom_items:nitrite 15'},
                    rarity = 1
                },
                {
                    items = {'aom_items:sulphur 2'},
                    rarity = 1
                },
            },
        } or nil,
        sounds = aom_sounds.default_snow(),
        on_timer = (i < count) and on_timer or nil,
        on_construct = (i < count) and on_construct or nil,
        _on_node_update = (i < count) and _on_node_update or nil,
    })
end

aom_tcraft.register_craft({
    output = "aom_compost:compost_0",
    items = {
        ["aom_items:plant_fibre"] = 1,
    },
})
