local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_explosives = {}


local flat_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, (-7.9)/16, (-8/16),
            ( 8)/16, (-7.8)/16, ( 8/16),
        },
    },
}

local function do_particles(p)
    minetest.add_particlespawner({
        amount = 30,
        time = 0.01,
        collisiondetection = false,
        collision_removal = false,
        object_collision = false,
        -- attached = self.object, -- to object ref
        vertical = false, -- If true face player using y axis only:-- If true face player using y axis only:
        texture = "gm_windmills_rocket_smoke.png",
        glow = 2,
        minpos = vector.new(p.x - 2, p.y - 2, p.z - 2),
        maxpos = vector.new(p.x + 2, p.y + 2, p.z + 2),
        minvel = vector.new(-1, -1, 1),
        maxvel = vector.new(1, 1, 1),
        minexptime = 0.5,
        maxexptime = 2,
        minsize = 6,
        maxsize = 12,
    })
    minetest.add_particlespawner({
        amount = 30,
        time = 0.01,
        collisiondetection = false,
        collision_removal = false,
        object_collision = false,
        -- attached = self.object, -- to object ref
        vertical = false, -- If true face player using y axis only:-- If true face player using y axis only:
        texture = "gm_windmills_rocket_spark.png",
        glow = 8,
        minpos = vector.new(p.x - 1, p.y - 1, p.z - 1),
        maxpos = vector.new(p.x + 1, p.y + 1, p.z + 1),
        minvel = vector.new(-6, -6, -6),
        maxvel = vector.new( 6,  6,  6),
        minexptime = 0.5,
        maxexptime = 1,
        minsize = 1,
        maxsize = 2,
    })
    minetest.add_particlespawner({
        amount = 30,
        time = 0.01,
        collisiondetection = false,
        collision_removal = false,
        object_collision = false,
        -- attached = self.object, -- to object ref
        vertical = true, -- If true face player using y axis only:-- If true face player using y axis only:
        texture = "gm_windmills_rocket_flame.png",
        glow = 5,
        minpos = vector.new(p.x - 1, p.y - 1, p.z - 1),
        maxpos = vector.new(p.x + 1, p.y + 1, p.z + 1),
        minvel = vector.new(-2, -2, -2),
        maxvel = vector.new( 2,  2,  2),
        minexptime = 1,
        maxexptime = 2,
        minsize = 1,
        maxsize = 2,
    })
end

minetest.register_node("aom_explosives:dynamite", {
    description = S("Dynamite"),
    _tt_long_desc = S("That's not how you make dynamite..."),
    _tt_how_to_use = S("Explodes after 2 seconds and destroys 3x3x3 nodes behind it"),
    tiles = {
        "aom_explosives_dynamite.png",
    },
    inventory_image = "aom_explosives_dynamite.png",
    groups = { item_dynamite = 1, dig_immediate = 3, explosive = 1, no_paint = 1, tool = 1, },
    drawtype = "signlike",
    selection_box = flat_box,
    sunlight_propagates = true,
    paramtype2 = "wallmounted",
    paramtype = "light",
    walkable = false,
    backface_culling = false,
    use_texture_alpha = "clip",
    sounds = aom_sounds.default_wood(),
    on_timer = function(pos, elapsed)
        local node = minetest.get_node(pos)
        minetest.set_node(pos, {name="air"})
        local p = pos + (minetest.wallmounted_to_dir(node.param2) * 2)
        aom_combat.explosions.explode(p, {
            radius = 1,
            cubic_radius = true,
            -- owner = self.object,
            no_drops = false,
            damage_range_factor = 4,
            damage_groups = {
                fleshy = 25,
                sharp = 15,
                blunt = 15,
            },
            groupcaps = {
                cracky = {max_drop_level=1} -- can only dig natural type / weak stone nodes
            }
        })
        minetest.sound_play("gm_windmills_rocket_explode", {
            gain = 1,
            pos = pos,
            max_hear_distance = 100,
        })
        do_particles(p)
    end,
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        local nt = minetest.get_node_timer(pos)
        nt:start(2)
        minetest.sound_play("aom_explosives_lighter", {
            gain = 2,
            pos = pos,
            max_hear_distance = 10,
        })
        minetest.sound_play("aom_explosives_fuse", {
            gain = 1,
            pos = pos,
            max_hear_distance = 10,
        })
    end,
    _on_node_update = function(pos, cause, user, data)
        if not ({dig=true, set=true})[cause] then return end
        local p = pos + core.wallmounted_to_dir(core.get_node(pos).param2)
        local node = core.get_node_or_nil(p)
        if not node then return end
        if core.get_item_group(node.name, "solid") <= 0 then
            core.dig_node(pos, user)
            return false, true
        end
    end,
})

if minetest.get_modpath("aom_tcraft") then
    aom_tcraft.register_craft({
        output = "aom_explosives:dynamite 10",
        items = {
            ["aom_items:gunpowder"] = 10,
        },
    })
end

