local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local adjacent = {
    [0] = vector.new( 0,-1, 0),
    [1] = vector.new( 0, 1, 0),
    [2] = vector.new( 1, 0, 0),
    [3] = vector.new(-1, 0, 0),
    [4] = vector.new( 0, 0, 1),
    [5] = vector.new( 0, 0,-1),
}
local function get_adjacent_outputs(pos, exclude)
    local out = {}
    for i=0, #adjacent do
        local p = vector.add(pos, adjacent[i])
        if not vector.equals(p, exclude) then
            out[#out+1] = p
        end
    end
    return out
end


local function get_formspec()
    local fs, size = aom_inventory.player.get_formspec(nil)
    local y = 12-size.y-2
    return table.concat({
        fs,
        aom_inventory.get_9patch(10, y-1.5, 2, 2, aom_inventory.get_bg9patch_texture("#8e6e59"), "false", "32"),
        ((aom_inventory and aom_inventory.get_itemslot_array(10.5, y-1, 1, 1)) or ""),
        "list[context;main;10.5,"..tostring(y-1)..";1,1;]",
        "listring[context;main]",
        "listring[current_player;main]"
    })
end


local function fix_formspec(pos)
    -- set up the formspec and stuff
    local meta = minetest.get_meta(pos)
    local formspec = get_formspec()
    if meta:get_string("formspec") == formspec then return end
    meta:set_string("formspec", formspec)
    meta:set_string("infotext", "Distributor");
    local inv = meta:get_inventory()
    inv:set_size("main", 1)
    return true
end

minetest.register_node('aom_pipes:distributor', {
    description = S("Item Distributor"),
    _tt_color = 3,
    _tt_long_desc = S("Moves items equally to all adjacent inventories except the one it is facing away from (red)."),
    groups = { full_solid = 1, cracky = 1, oddly_breakable_by_hand = 2, solid = 1, mechanisms = 1, suffocates = 0, pipe = 1, distributor = 1},
    tiles = {
        "aom_pipes_distributor.png^[transformFY",
        "aom_pipes_distributor.png",
        "aom_pipes_distributor.png^[transformR90",
        "aom_pipes_distributor.png^[transformR270",
        "aom_pipes_distributor_front.png",
        "aom_pipes_distributor_back.png",
    },
    -- tiles = {"aom_pipes_distributor_back.png", "aom_pipes_distributor_front.png", "aom_pipes_distributor.png",},
    sounds = aom_sounds.default_wood(),
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    connects_to = { "group:pipe", "group:storage", "group:chest", "group:cooker" },
    on_place = aom_util.rotate_and_place_against,
    on_timer = function(pos, elapsed)
        local from_pos = aom_pipes.get_dir_of_node(pos)
        from_pos = vector.subtract(pos, from_pos)
        local outputs = get_adjacent_outputs(pos, from_pos)
        local meta = core.get_meta(pos)
        local o = tonumber(meta:get_string("pipe_distr_offset")) or 1
        local ret = false
        for i=1, aom_pipes.item_move_count*5 do
            ret = aom_pipes.move_item_to(pos, outputs[(i+o) % (#outputs)+1], 1) or ret
        end
        meta:set_string("pipe_distr_offset", tostring((o+1) % #outputs))
        if ret then
            local nt = minetest.get_node_timer(from_pos)
            if not nt:is_started() then
                nt:start(1)
            end
        end
        return ret
    end,
    on_construct = function(pos)
        -- tell the game what node it's pointing into
        local node = minetest.get_node(pos)
        local dir = minetest.facedir_to_dir(node.param2)
        aom_pipes.set_meta_vector(pos, dir)
        fix_formspec(pos)
        -- start the timer
        minetest.get_node_timer(pos):start(1.0)
    end,
        on_destruct = function(pos)
        aom_inventory.drop_contents(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        fix_formspec(pos)
    end,
    on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        aom_pipes.start_timer(pos)
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        aom_pipes.start_timer(pos)
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        aom_pipes.start_timer(pos)
    end,
    _has_formspec = true,
})

if true then
    local s = "aom_items:copper_sheet"
    local p = "aom_pipes:pipe"
    minetest.register_craft({
        output = "aom_pipes:distributor 2",
        recipe = {
            {"", p, ""},
            { p,"", p},
            {"", p, ""},
        },
    })
end
