local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_combat.defaults = {}

local function debug(text)
    -- minetest.log(text)
end

aom_combat.defaults.sword = {
    description = S("Test Sword"),
    _tt_color = "#fea",
    inventory_image = "aom_combat_test_sword.png",

    _aom_combat_get_attack = function(itemstack)
        return {
            base_damage = {
                cut = 8,
                blunt = 3,
            },
            max_base_damage = 8,
            knockback_mult = 4,
        }
    end,
    _on_attack_sent = function(attacker, stack, atk)
        debug("sword used, sent attack and added mults")
        minetest.sound_play(("aom_combat_metal_hit"), {
            gain = 0.3,
            object = attacker,
            max_hear_distance = 30,
        })
        return atk
    end,
    _can_block_attack = function(stack, player, atk)
        return nil -- prevent blocking multiple
    end,
    _on_block_attack = function(stack, player, atk)
        debug("blocked an attack")
        minetest.sound_play(("aom_combat_metal_hit"), {
            gain = 0.7,
            object = player,
            max_hear_distance = 30,
        })
    end,
    _on_sent_attack_blocked = function(stack, player, atk)
        minetest.sound_play(("aom_combat_metal_hit"), {
            gain = 0.7,
            object = player,
            max_hear_distance = 30,
        })
    end,
    on_secondary_use = function(itemstack, user, pointed_thing)
        if not core.is_player(user) then return end
        local mode = aom_combat.cooldown.get_mode(itemstack)
        if mode == "" then
            local duration = itemstack:get_definition()._aom_combat_block_duration or 1
            aom_combat.attack.declare_blocking(user, duration, function() return nil end)
            debug("blocking start")
            minetest.sound_play(("aom_combat_block_start"), {
                gain = 0.3,
                object = user,
                max_hear_distance = 10,
            })
            return aom_combat.cooldown.custom_start(itemstack, user, duration, "block")
        end
    end,
    _on_step = function(itemstack, player, dtime)
        local ctrl = player:get_player_control()
        local mode = aom_combat.cooldown.get_mode(itemstack)

        if (ctrl and not ctrl.dig) then
            if mode == "complete" then
                debug("on sword swing")
                local range = itemstack:get_definition()._aom_combat_attack_range or 4
                itemstack = aom_combat.attack.blindly_attack_with_raycast(itemstack, player, range, nil, nil) or itemstack
                minetest.sound_play(("aom_whap"), {
                    gain = 0.9,
                    object = player,
                    max_hear_distance = 50,
                    pitch = (math.random()*0.1) + 1,
                    start = 0.05,
                })
                return aom_combat.cooldown.cooldown_start(itemstack, player)
            elseif mode == "windup" then
                -- return aom_combat.cooldown.cooldown_complete(itemstack, player)
            end
        end
    end,

    _on_deselect = function(itemstack, player)
        return aom_combat.cooldown.cooldown_complete(itemstack, player)
    end,

    on_use = function(itemstack, user, pointed_thing)
        if not core.is_player(user) then return end
        if aom_combat.cooldown.can_use(itemstack) then
            minetest.sound_play(("aom_sword_draw"), {
                gain = 0.1,
                object = user,
                max_hear_distance = 10,
                pitch = 1.2
            })
            return aom_combat.cooldown.windup_start(itemstack, user)
        end
    end,

    _on_windup_complete = function(itemstack, player)
    end,

    _on_custom_cooldown_start = function(itemstack, player)
    end,

    _on_custom_cooldown_complete = function(itemstack, player)
        debug("custom cooldown complete.")
    end,

    _windup = 0.2,
    -- _cooldown = 0.0,

    tool_capabilities = {
        full_punch_interval = 1,
    },
    groups = { combat = 1, sword = 1 },
}

minetest.register_tool("aom_combat:test_sword", aom_combat.defaults.sword)

function aom_combat.register_swordlike(name, def)
    for k, v in pairs(aom_combat.defaults.sword) do
        if def[k] == nil then
            def[k] = v
        end
    end
    minetest.register_tool(name, def)
end
