
local grassnodelist = {
    "aom_flora:grass_0",
    "aom_flora:grass_1",
    "aom_flora:grass_2",
    "aom_flora:grass_3",
}

local function get_random_grass()
    -- do return "aom_underworld:glow_rock" end
    return grassnodelist[math.random(1, #grassnodelist)]
end

local np = {
    offset = 0.4,
    scale = 0.5,
    spread = {x = 2, y = 2, z = 2},
    seed = 54256 + (core.get_mapgen_setting("seed") or 0),
    octaves = 2,
    persist = 0.01,
    lacunarity = 2.317,
}

local iperlin = PerlinNoise(np)

local mg_name = core.get_mapgen_setting("mg_name")
if mg_name and (mg_name ~= "flat") and (mg_name ~= "singlenode") then
    core.register_abm({
        nodenames = {"group:grass_block"},
        neighbors = {"air"},
        -- interval = 1.0,
        -- chance = 4,
        interval = 30.0,
        chance = 300,
        action = function(pos, node, active_object_count, active_object_count_wider)
            local p = vector.offset(pos, 0, 1, 0)
            if iperlin:get_3d(p) < 0.55 then return end
            if core.get_item_group(node.name, "full_solid") == 0 then return end
            if (core.get_node_light(p, 0.5) or 0) < 4 then return end
            local n = core.get_node(p)
            if (n.name ~= "air") then return end
            local shape = math.random(0,3)
            core.set_node(p, {
                name=get_random_grass(),
                param2=shape+8+(math.random(0,1)*16)
            })
        end
    })
    core.register_abm({
        nodenames = {"group:grass"},
        -- interval = 1.0,
        -- chance = 4,
        interval = 30.0,
        chance = 300,
        action = function(pos, node, active_object_count, active_object_count_wider)
            if iperlin:get_3d(pos) < 0.55 then
                core.set_node(pos, {name="air"})
                return
            end
            local b = core.get_node(pos)
            if core.get_item_group(b.name, "full_solid") == 0 then return end
            local p = vector.new(pos.x, pos.y+1, pos.z)
            if (core.get_node_light(p, 0.5) or 0) < 4 then return end
            local n = core.get_node(p)
            -- if (n.name ~= "air") then return end
            local shape = math.random(0,3)
            core.set_node(p, {
                name=get_random_grass(),
                param2=shape+8+(math.random(0,1)*16)
            })
        end
    })
end