local S = core.get_translator(core.get_current_modname())

local default_craft_count = 8

aom_dyes.dye_list = {}

local function register_dye(color_name, desc, from_items, colorstring, flags)
    if not flags then flags = {} end
    local low = string.lower(color_name)
    low = string.gsub(low, " ", "_")
    local name = "aom_dyes:" .. low

    aom_dyes.dye_list[#aom_dyes.dye_list+1] = {
        dye_item_name = name,
        color_name = color_name,
        name = low,
        color = colorstring,
        colorize_amount = flags.colorize_amount
    }

    minetest.register_craftitem(name, {
        -- TL: @1 is a dye color ("Blue")
        description = S("@1 Dye", color_name),
        inventory_image = "aom_dyes_base.png"..
        "^[multiply:"..colorstring.."^[colorize:"..colorstring..":"..(flags.colorize_amount or 0),
        groups = { craftitem = 1, dye = 1, ["dye_" .. low] = 1 },
    })

    if flags.no_craft then return end
    if minetest.get_modpath("aom_tcraft") then
        aom_tcraft.register_craft({
            output = name.." "..(flags.craft_count or default_craft_count),
            items = from_items
        })
    end
end

register_dye("Blue",
	S("Blue"),
    {["aom_items:lapis_lazuli"]=1},
	"#4155e6",
	{colorize_amount = 100})
register_dye("Light Blue",
	S("Light Blue"),
    {["aom_dyes:blue"]=1, ["aom_dyes:white"]=1},
	"#85a9ff",
	{colorize_amount = 100, craft_count = 2})
register_dye("Green",
	S("Green"),
    {["aom_dyes:yellow"]=1, ["aom_dyes:blue"]=1},
	"#57a856",
	{colorize_amount = 50})
register_dye("Dark Green",
	S("Dark Green"),
    {["aom_dyes:green"]=1, ["aom_dyes:black"]=1},
	"#3c784d",
	{colorize_amount = 50, craft_count = 2})
register_dye("Yellow",
	S("Yellow"),
    {["aom_flora:flower_yellow"]=1},
	"#fff959",
	{colorize_amount = 150})
register_dye("Orange",
	S("Orange"),
    {["aom_dyes:yellow"]=1, ["aom_dyes:red"]=1},
	"#ff883c",
	{colorize_amount = 150, craft_count = 2})
register_dye("Brown",
	S("Brown"),
    {["aom_dyes:orange"]=1, ["aom_dyes:black"]=1},
	"#9a6d59",
	{colorize_amount = 150, craft_count = 2})
register_dye("Red",
	S("Red"),
    {["aom_flora:flower_red"]=1},
	"#f84639",
	{colorize_amount = 100})
register_dye("Dark Red",
	S("Dark Red"),
    {["aom_dyes:red"]=1, ["aom_dyes:black"]=1},
	"#a53349",
	{colorize_amount = 100})
register_dye("Pink",
	S("Pink"),
    {["aom_dyes:red"]=1, ["aom_dyes:white"]=1},
	"#ffbcf9",
	{colorize_amount = 150})
register_dye("Purple",
	S("Purple"),
    {["aom_dyes:red"]=1, ["aom_dyes:blue"]=1},
	"#9d49cc",
	{colorize_amount = 100, craft_count = 2})
register_dye("Black",
	S("Black"),
    {["aom_items:charcoal"]=1},
	"#333333",
	{colorize_amount = 100})
register_dye("Grey",
	S("Grey"),
    {["aom_items:charcoal"]=1},
	"#7b7b7b",
	{colorize_amount = 100})
register_dye("Light Grey",
	S("Light Grey"),
    {["aom_items:charcoal"]=1},
	"#d2d2d2",
	{colorize_amount = 100})
register_dye("White",
	S("White"),
    {["aom_stone:limestone"]=1},
	"#ffffff",
	{colorize_amount = 200})
