local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)


local function get_formspec()
    local fs, size = aom_inventory.player.get_formspec(nil)
    local y = 12-size.y-2.3

    return table.concat({
        fs,
        aom_inventory.get_9patch(5.5, y-2.79, 11, 4, aom_inventory.get_bg9patch_texture("#458"), "false", 32),
        aom_inventory.get_itemslot_array(6, y-2.2, 10, 3, nil, "#223"),
        "list[context;main;6,"..tostring(y-2.2)..";10,3;]",
        "listring[context;main]",
        "listring[current_player;main]"
})
end

local function set_up_inventory(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local formspec = get_formspec()
    if meta:get_string("formspec") == formspec then return end
    inv:set_size("main", 10*3)
    meta:set_string("formspec", formspec)
    meta:set_string("infotext", "Chest");
    return true
end

minetest.register_node('aom_storage:chest', {
    description = S("Wooden Chest"),
    _tt_long_desc = S("Stores items."),
    groups = { oddly_breakable_by_hand = 2, choppy = 1, solid = 1, furniture = 1, suffocates = 0, wood = 1, item_wooden_chest = 1, storage = 1, chest = 1 },
    tiles = {"aom_storage_chest.png"},
    mesh = "aom_storage_chest.b3d",
    drawtype = "mesh",
    paramtype = "light",
    sounds = aom_sounds.default_wood(),
    paramtype2 = "facedir",
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    on_construct = function(pos)
        set_up_inventory(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        set_up_inventory(pos)
    end,
    on_destruct = function(pos)
        aom_inventory.drop_contents(pos)
    end,
    _on_node_update = function(pos, cause, user, data)
        if set_up_inventory(pos) then return true end
    end,
    _has_formspec = true,
})


if true then
    aom_tcraft.register_group_craft({
            output = "aom_storage:chest",
            items = {},
            group = "planks",
            group_count = 8
    })
end
