
function aom_gates.get_collisionbox(width, length)
    local pw = width or (2/16)
    local pl = length or (8/16)
    local nodebox = {
        type = "connected",
        fixed = {
            {
                -pw, -pw, -pw,
                pw, pw, pw
            },
        },
        connect_top = {
            -pw, pw, -pw,
            pw, pl, pw
        },
        connect_bottom = {
            -pw, -pl, -pw,
            pw, -pw, pw
        },
        connect_front = {
            -pw, -pw, -pl,
            pw, pw, -pw
        },
        connect_left = {
            -pl, -pw, -pw,
            -pw, pw, pw
        },
        connect_back = {
        -pw, -pw, pw,
            pw, pw, pl
        },
        connect_right = {
            pw, -pw, -pw,
            pl, pw, pw
        },
    }
    return nodebox
end
