
aom_statusfx.register_status("woozy", {
    ----
    fx_allow_player = true,
    fx_allow_object = true,
    -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
    fx_only_tick_once = false,
    fx_only_apply_once = true,
    fx_timeout_individual = false,
    fx_use_player_functions_for_objects = true,
    ----
    on_apply_player = function(object, count, meta, params)
        meta.next_time = math.floor(meta.time)
        return false -- true to prevent apply
    end,
    on_remove_player = function(object, count, meta, not_timeout)
        return false -- true to prevent remove
    end,
    on_step_player = function(object, count, meta, dtime)
        if meta.next_time and meta.next_time < meta.time - 1 then
            meta.next_time = meta.time - math.random()*0.2 - 0.1
        end
        if meta.next_time > meta.time then
            meta.next_time = meta.time - math.random()*0.2 - 0.1
        else
            return false
        end

        local vel = vector.new(
            (math.random()-0.5)*2 * 4,
            0.5,
            (math.random()-0.5)*2 * 4
        )
        object:add_velocity(vel)
        return false -- true to remove
    end,
    ----
    hud = aom_statusfx.hud.make_effect("aom_status_woozy.png")
    ----
})
