local sealevel = aom_underworld.sea_level
local alt_max = aom_underworld.alt_max
local alt_min = aom_underworld.alt_min
local sch = aom_underworld.get_schematic_path


local this_biome = "underworld_arlior_meadow"

---------------
-- FOG CANYONS
---------------
local size = 120
local noise_params    = {
    offset = sealevel + alt_max / 2,
    scale = math.abs(alt_max - alt_min)*2,
    spread = {x = size, y = size, z = size},
    seed = 6745,
    octaves = 3,
}
size = 90
local np_stratum_thickness = {
    offset = -200,
    scale = 400,
    spread = {x = size, y = size, z = size},
    seed = 654,
    octaves = 3,
    persistence = 0.7
}
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:fog_10",
    wherein        = {"aom_underworld:lava_rock"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params         = noise_params,
    np_stratum_thickness = np_stratum_thickness,
    stratum_thickness = 20,
    biomes = { this_biome },
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:fog",
    wherein        = {"aom_underworld:worknode_ceiling"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params         = noise_params,
    np_stratum_thickness = np_stratum_thickness,
    stratum_thickness = 20,
    biomes = { this_biome },
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "air",
    wherein        = {"aom_underworld:worknode_topsoil", "aom_underworld:worknode_dust", "aom_underworld:worknode_soil"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params         = noise_params,
    np_stratum_thickness = np_stratum_thickness,
    stratum_thickness = 20,
    biomes = { this_biome },
})


-- holes in surface
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:arlior",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
      offset = alt_min + alt_max / 2,
      scale = math.abs(alt_max - alt_min)/ 2,
      spread = {x = 50, y = 50, z = 50},
      seed = 54376,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = -2000,
      scale = 7000,
      spread = {x = 10, y = 10, z = 10},
      seed = 4388,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
  })



minetest.register_ore({
    ore_type = "stratum",
    ore      = "aom_underworld:arlioran",
    wherein  = {"aom_underworld:worknode_topsoil"},
    y_min = aom_underworld.alt_min,
    y_max = aom_underworld.alt_max,
    biomes = { this_biome }
})

minetest.register_ore({
    ore_type = "stratum",
    ore      = "aom_underworld:arlior",
    wherein  = {"aom_underworld:worknode_soil", "aom_underworld:lava_rock", "aom_underworld:worknode_ceiling",},
    y_min = aom_underworld.alt_min,
    y_max = aom_underworld.alt_max,
    biomes = { this_biome }
})
