local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(minetest.get_current_modname())


minetest.register_chatcommand("statuseffect", {
    params = "([status name] [duration] (player name))",
    description = S("Gives statuses"),
    privs = {give = true},
    func = function(name, param)
        local parse = string.split(param, " ")
        local status = (aom_statusfx.registered_status_effects[parse[1]] ~= nil) and parse[1]
        if not status then
            return false, S("Error: no status with name \"@1\"", parse[1])
        end

        local dur = tonumber(parse[2])
        if not dur then
            return false, S("Error: invalid duration")
        end

        if param[3] then
            if minetest.get_player_by_name(param[3]) then
                name = param[3]
            else
                return false, S("Error: invalid player name \"@1\"", param[3])
            end
        end
        aom_statusfx.apply_status(minetest.get_player_by_name(name), status, dur)
        --TL: @1 is status name ("blindness"), @2 is player name ("Greg"), @3 is a number ("200")
        return true, S("Applied status @1 to @2 for @3 seconds.", status, name, tostring(dur))
    end
})
