local S = core.get_translator(core.get_current_modname())

aom_trees.grow_tree = {}

aom_trees.schematics = {}

function aom_trees.register_sapling(name)
    local node_name = string.lower(name)
    aom_trees.grow_tree[node_name] = aom_trees.grow_tree[node_name] or function() return nil end

    minetest.register_node(("aom_trees:" .. node_name .. "_sapling"), {
        description = S("@1 Sapling", name),
        drawtype = "plantlike",
        waving = 1,
        visual_scale = 1.0,
        tiles = {"aom_sapling_" .. node_name .. ".png"},
        inventory_image = "aom_sapling_" .. node_name .. ".png",
        wield_image = "aom_sapling_" .. node_name .. ".png",
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        buildable_to = true,
        groups = { nature = 1, ["item_"..node_name.."_sapling"] = 1, attached_node = 1, player_place_only = 1, dig_immediate = 3, sapling = 1,},
        -- drop = {"aom_trees:" .. node_name .. "_sapling"},
        -- sounds = {},
        selection_box = {
            type = "fixed",
            fixed = {-5/16, -8/16, -5/16, 5/16, 1/16, 5/16},
        },
        is_ground_content = true,
        _tree_type = node_name,
        _tree_grow = function(pos, node)
            if type(aom_trees.grow_tree[name]) == "function" then
                aom_trees.grow_tree[name](pos, node)
            else
                aom_trees.grow_tree.general(pos, node_name)
            end
        end,
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
    })
end

aom_trees.register_sapling("Oak")
aom_trees.register_sapling("Ash")
aom_trees.register_sapling("Spruce")


-- schematics and growing trees
local sch = aom_sch.get_schematic_path

function aom_trees.register_tree_schematic(kind, name)
    aom_trees.schematics[kind] = aom_trees.schematics[kind] or {}
    aom_trees.schematics[kind][#aom_trees.schematics[kind]+1] = sch(name)
end

-- OAK
aom_trees.register_tree_schematic("oak", "tree_oak_0")
aom_trees.register_tree_schematic("oak", "tree_oak_1")
aom_trees.register_tree_schematic("oak", "tree_oak_2")
aom_trees.register_tree_schematic("oak", "tree_oak_huge_0")
aom_trees.register_tree_schematic("oak", "tree_oak_huge_1")
aom_trees.register_tree_schematic("oak", "tree_oak_huge_2")

-- ASH
aom_trees.register_tree_schematic("ash", "tree_ash_0")
aom_trees.register_tree_schematic("ash", "tree_ash_1")
aom_trees.register_tree_schematic("ash", "tree_ash_2")
aom_trees.register_tree_schematic("ash", "tree_ash_3")
aom_trees.register_tree_schematic("ash", "tree_ash_huge_0")

-- SPRUCE
aom_trees.register_tree_schematic("spruce", "tree_spruce_1")
aom_trees.register_tree_schematic("spruce", "tree_spruce_2")
aom_trees.register_tree_schematic("spruce", "tree_spruce_3")
aom_trees.register_tree_schematic("spruce", "tree_spruce_tall_0")
aom_trees.register_tree_schematic("spruce", "tree_spruce_tall_1")
aom_trees.register_tree_schematic("spruce", "tree_spruce_tall_2")
aom_trees.register_tree_schematic("spruce", "tree_spruce_tall_3")
aom_trees.register_tree_schematic("spruce", "tree_spruce_tall_4")


function aom_trees.grow_tree.general(pos, name)
    minetest.set_node(pos, {name = "air"})

    if not aom_trees.schematics[name] then
        minetest.log("error", "Warning, unable to place sapling type " .. tostring(name) .. " at " .. dump(pos))
        return end
    local variant = math.random(1, #aom_trees.schematics[name])
    variant = aom_trees.schematics[name][variant]
    minetest.place_schematic(pos, variant, "random", nil, false, {place_center_x=true, place_center_z=true})
end
