
# Fonts

## Declaring a font
You need to supply textures for each character in your font. These by default are in the format of `prefix_04.png`. You can choose zero padding based on the exporter you use. For example Piskel zero pads based on the number of frames being exported. It's recommended to use a spritesheet and a program like this to cut it up into its parts.

By default, the order of the `characterset` field is the same order as the file names. So if `characterset` is "abc" then the file "myfont_2.png" will be the letter "c".

You can also define your own function that calculates the names of the font files using the `get_character_filename` field.

### To register a font
```lua
aom_fonts.register_font("F5x8", {
    -- a string with all the characters in the order that the files are in
    -- default is "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ.,;:?!-_~#\"\'&()[]{}<>\\/$%@+=*"
    characterset = aom_fonts.default_characterset,
    -- if your font only contains uppercase characters, setting this to "uppercase" will convert text automatically to uppercase
    case = "uppercase", -- "uppercase", "lowercase" or "both"
    -- the prefix is just used for the default way of determining which file is which character
    texture_prefix = "F5x8_",
    -- the size in pixels of each character
    char_size = vector.new(5,8,0),
    -- for the filename, how much zero padding is there? 004 --> 3, 04 --> 2 or 1 to disable
    zero_padding = 2,
    -- optional function to calc filename `get_character_filename(char)`
    get_character_filename = nil,
})
```


The following can be used to test it and see how it works.

### Example
```lua
minetest.register_on_joinplayer(function(player, last_login)
    local test = aom_fonts.get_texture_string("Hello World", "F5x8", {
        size = vector.new(128,64,0), -- size of the texture generated
        padding = vector.new(1,1,0), -- extra space between each letter
        offset = vector.new(0,0,0) -- moves all the text by pixels
    })

    minetest.chat_send_player(player:get_player_name(), "Text string is "..test)

    player:hud_add({
        type = "image",
        alignment = {x=0, y=-1},
        position = {x=0.5, y=0.5},
        name = "test",
        text = test,
        z_index = -1000,
        scale = {x = 4, y = 4},
        offset = {x = 0, y = 0},
    })
end)
```