local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

aom_mirecaves = {}
aom_mirecaves.max = 100
-- aom_mirecaves.max = aom_vars.overworld.sea_level - 30
aom_mirecaves.min = aom_vars.overworld.sea_level - 40

aom_mirecaves.biome_list = {"mirecaves"}

aom_mirecaves.mg_name = minetest.get_mapgen_setting("mg_name")

-- util
dofile(mod_path .. "/utilities.lua")

-- nodes
dofile(mod_path .. "/nodes" .. "/stone.lua")
dofile(mod_path .. "/nodes" .. "/nolmer.lua")
dofile(mod_path .. "/scripts" .. "/nolmer_growing.lua")
dofile(mod_path .. "/nodes" .. "/workaround.lua")

-- mapgen
-- dofile(mod_path .. "/mapgen" .. "/clearer.lua")
-- dofile(mod_path .. "/mapgen" .. "/streams.lua")
-- dofile(mod_path .. "/mapgen" .. "/soils.lua")


dofile(mod_path .. "/mapgen" .. "/biome.lua")
-- decor
dofile(mod_path .. "/mapgen" .. "/cleaner.lua")

if minetest.get_modpath("aom_map_base") and minetest.get_modpath("aom_stone") then
    aom_stone.register_ores_for_node("aom_mirecaves:stone")
    aom_map_base.register_ores_for_node("aom_mirecaves:stone", {
        skip = {
            coal = true,
            iron = true,
        }
    })
end
