local S = core.get_translator(core.get_current_modname())

local box = {
    type = "fixed",
    fixed = {
        {
            8/16, 8/16, 8/16, -8/16, 7/16, -8/16,
        },
        {
            8/16, 1/16, 8/16, -8/16, -8/16, -8/16,
        },
    }
}

local function scaffold_collapse(pos, cause, user, count, payload)
    if cause ~= "scaffold_collapse" then return false end
    -- minetest.chat_send_all(count)
    if user and minetest.is_player(user) then
        local name = minetest.get_node(pos).name
        minetest.set_node(pos, {name="air"})
        local inv = user:get_inventory()
        inv:add_item("main", ItemStack(name))
        return true
    end
end

minetest.register_node("aom_wood:scaffolding", {
    description = S("Scaffolding"),
    _tt_long_desc = S("Scaffolding which can be placed and destroyed with ease."),
    groups = { item_scaffolding = 1, flammable = 1, dig_immediate = 3, solid = 1, scaffolding = 1 },
    paramtype2 = "4dir",
    tiles = {
        "aom_scaffolding_top.png",
        "aom_scaffolding_side.png",
        "aom_scaffolding_side.png",
    },
    backface_culling = true,
    use_texture_alpha = "opaque",
    sounds = aom_sounds.default_wood(),
    on_place = function(itemstack, placer, pointed_thing)
        itemstack = ItemStack(itemstack)
        local ret = aom_util.try_rightclick(itemstack, placer, pointed_thing, false)
        if ret then
            return ret
        end
        if not core.is_player(placer) then
            minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
        end
        local below_pos = placer:get_pos()
        below_pos.y = below_pos.y - 1
        local is_player = minetest.is_player(placer)
        local look_dir = placer:get_look_dir()

        local facedir = minetest.dir_to_fourdir(look_dir)

        local should_place_normally = false
        if not (pointed_thing.above.y >= pointed_thing.under.y + 1) then
            should_place_normally = true
        end
        if not should_place_normally then
            local ctrl = placer:get_player_control()
            local node_under = minetest.get_node(pointed_thing.under)
            should_place_normally = should_place_normally or (not ctrl.aux1) or node_under.name ~= "aom_wood:scaffolding"
        end
        if should_place_normally then
            local ret2 = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
            return ret2
        end

        local dir = look_dir
        dir.y = 0
        dir = vector.normalize(dir)

        local to_pos = vector.copy(pointed_thing.under)

        for i = 0, 6 do
            to_pos = vector.add(to_pos, dir)
            local node = minetest.get_node(to_pos)
            local def = minetest.registered_nodes[node.name]
            if def and def.buildable_to then
                minetest.dig_node(to_pos)
                minetest.set_node(to_pos, {name=itemstack:get_name()})
                local n = minetest.get_node(to_pos)
                n.param2 = facedir
                minetest.set_node(to_pos, n)
                if not minetest.is_creative_enabled(placer:get_player_name()) then
                    itemstack:take_item()
                end
                return itemstack
            end
        end
    end,
})
if minetest.get_modpath("aom_tcraft") then
    aom_tcraft.register_craft({
        output = "aom_wood:scaffolding 4",
        items = {
            ["aom_items:stick"] = 8,
        },
        tags = {
            "tools"
        }
    })
end



local flat_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, (-7.9)/16, (-8/16),
            ( 8)/16, (-7.8)/16, ( 8/16),
        },
    },
}

minetest.register_node('aom_wood:crude_ladder', {
    -- TL: wooden ladder node
    description = S("Crude Ladder"),
    _tt_long_desc = S("Can be climbed."),
    groups = { item_crude_ladder = 1, dig_immediate = 3, player_place_only = 1, furniture = 1, ladder = 1 },
    drawtype = "signlike",
    -- node_box = flat_box,
    selection_box = flat_box,
    sunlight_propagates = true,
    paramtype2 = "wallmounted",
    paramtype = "light",
    tiles = {
        "aom_crude_ladder.png",
    },
    walkable = false,
    climbable = true,
    backface_culling = false,
    use_texture_alpha = "clip",
    sounds = aom_sounds.default_wood(),

    on_place = function(itemstack, placer, pointed_thing)
        local ret = aom_util.try_rightclick(itemstack, placer, pointed_thing, false)
        if ret then
            return ret
        end
        local node_under = minetest.get_node(pointed_thing.under)
        if minetest.get_item_group(node_under.name, "full_solid") == 0 then
            return itemstack
        else
            return minetest.item_place_node(itemstack, placer, pointed_thing)
        end
    end,
    _on_node_update = function(pos, cause, user, data)
        local ret = false
        ret = scaffold_collapse(pos, cause, user, data)
        local node = minetest.get_node(pos)
        local mountdir = minetest.wallmounted_to_dir(node.param2)
        local mountnode = minetest.get_node(vector.add(pos, mountdir))
        if (mountdir.y == 1 or mountdir.y == -1) or minetest.get_item_group(mountnode.name, "full_solid") == 0 then
            minetest.dig_node(pos)
            ret = true
        end

        if ret then return true
        else return false end
    end,
})
if true then
    local s = "aom_items:stick"
    minetest.register_craft({
      output = "aom_wood:crude_ladder 16",
      recipe = {
        {s,"", s},
        {s, s, s},
        {s,"", s},
      },
    })
end
