local S = core.get_translator(core.get_current_modname())

function aom_inventory.drop_contents(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    return aom_inventory.drop_inventory_at_pos(inv, pos)
end


function aom_inventory.drop_inventory_at_pos(inv, pos)
    local inv_lists = inv:get_lists()
    for list_name, list in pairs(inv_lists) do
        if not inv:is_empty(list_name) then
            for i=0, inv:get_size(list_name) do
                local stack = inv:get_stack(list_name, i)
                minetest.add_item(pos, stack)
            end
        end
        inv:set_list(list_name, {})
    end
    return true
end


local has_settings = minetest.get_modpath("aom_settings") ~= nil
if has_settings then
    -- TL: setting description
    aom_settings.register_setting("gameplay_drop_items_on_death", false, S("Drop items on death"), "server")
end
minetest.register_on_dieplayer(function(player, reason)
    if not has_settings then return
    elseif not aom_settings.get_setting(player, "gameplay_drop_items_on_death", false) then return end
    local inv = player:get_inventory()
    return aom_inventory.drop_inventory_at_pos(inv, player:get_pos())
end)
