

local vmax = aom_underworld.alt_max
local vmin = aom_underworld.alt_min


local size = 1000
local c = math.floor(math.abs(vmax - vmin)/100)
local thickness = -590
local craziness = 500
-- local i = 1
for i=1, c do
  -- add some back in
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "air",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + 100,
      scale = 2000,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = craziness,
      spread = {x = 100, y = 100, z = 10},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:lava_rock",
    wherein        = {"air", "aom_underworld:worknode_dust", "aom_underworld:worknode_topsoil", },
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + 100,
      scale = 1000,
      spread = {x = size, y = size, z = size},
      seed = 559 + i*16,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = craziness,
      spread = {x = 100, y = 100, z = 10},
      seed = 8976 + i * 276,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
end

minetest.register_ore({
  ore_type       = "stratum",
  ore            = "aom_underworld:lava_rock",
  wherein        = {"aom_underworld:workaround_node"},
  y_min = vmin,
  y_max = vmax,
})
