
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'oak_forest'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:dirt_with_grass',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = alt_max,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 59,
    humidity_point = 75,
}, {"forest", "oak", "overworld", "mushrooms"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path


-- GRASS
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:grass_variant_1",
    wherein		= {"aom_soil:dirt_with_grass"},
    clust_scarcity	= 200,
    clust_num_ores	= 6,
    clust_size	= 7,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = 80, y = 80, z = 80},
        seed = 64758,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})

-- GRASS
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:grass_variant_2",
    wherein		= {"aom_soil:grass_variant_1"},
    clust_scarcity	= 200,
    clust_num_ores	= 6,
    clust_size	= 5,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = 80, y = 80, z = 80},
        seed = 6534,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})

minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "aom_soil:grass_variant_3",
    wherein		= {"aom_soil:grass_variant_1"},
    clust_scarcity	= 100,
    clust_num_ores	= 2,
    clust_size	= 4,
    y_max = alt_max,
    y_min = alt_min,
    biomes = {this_biome,},
})


-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.004,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_small_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:grass_variant_2", "aom_soil:grass_variant_1"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_small_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- bushes in large sparse clumps
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.001,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})




-- GRASS VARIANT (do after trees so there are some spots not under trees)
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:grass_variant_1",
    wherein		= {"aom_soil:dirt_with_grass"},
    clust_scarcity	= 200,
    clust_num_ores	= 6,
    clust_size	= 7,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = 80, y = 80, z = 80},
        seed = 8758,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})
