local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_tool("aom_bow:bow", {
    description = S("Bow"),
    _tt_how_to_use = S("Hold [place] to draw bow") .. "\n" ..
        S("Release [place] when drawn to loose arrow"),
    wield_image = "aom_bow_0.png",
    inventory_image = "aom_bow_0.png",
    groups = { weapon = 1, item_burns = 1, },
    range = 0,
    on_secondary_use = function(itemstack, user, pointed_thing)
        return aom_combat.cooldown.attempt_to_use(itemstack, user, pointed_thing)
    end,
    on_place = function(itemstack, user, pointed_thing)
        return aom_combat.cooldown.attempt_to_use(itemstack, user, pointed_thing)
    end,
    _on_windup_start = function(itemstack, player)
        player_model.set_anim(player, {tag="aom_bow_bow_aim", actions={"aim"}})
        minetest.sound_play(("aom_bow_draw"), {
            gain = 0.5,
            object = player,
            max_hear_distance = 100,
            pitch = (math.random()*0.1) + 0.90
        })
    end,
    -- _on_windup_cancelled = function(itemstack, player)
    --     return itemstack
    -- end,
    _on_windup_complete = function(itemstack, player)
        minetest.sound_play(("aom_bow_draw_complete"), {
            gain = 0.9,
            object = player,
            max_hear_distance = 50,
        })
        return itemstack
    end,

    wield_scale = vector.new(2, 2, 2),

    _on_select = function(itemstack, player)
    end,
    _on_deselect = function(itemstack, player)
        player_model.unset_anim(player, "aom_bow_bow_aim")
        itemstack = aom_combat.cooldown.windup_cancel(itemstack, player) or itemstack
        local meta = itemstack:get_meta()
        meta:set_string("wield_image", "aom_bow_0.png")
        meta:set_string("inventory_image", "aom_bow_0.png")
        return aom_combat.cooldown.on_wield_change_from(itemstack, player)
    end,
    _on_step = function(itemstack, player, dtime)
        local just_thrown = false
        itemstack, just_thrown = aom_combat.throwable.on_wield_throwable(player, "aom_bow:arrow_ENTITY", itemstack, {
            allow_partial_throw = true,
            min_windup = 0.5,
        })
        local meta = itemstack:get_meta()
        local windup_factor = 1 - (itemstack:get_wear() / 65534)
        if windup_factor ~= 1 or (player:get_player_control() or {}).place then
            local img = "aom_bow_" .. math.floor(windup_factor * 3) .. ".png"
            if meta:get_string("wield_image") ~= img then
                meta:set_string("wield_image", img)
                meta:set_string("inventory_image", img)
            end
        end
        if just_thrown then
            wield3d.update(player, {
                _wield3d_textures = "blank.png",
            })
            player_model.unset_anim(player, "aom_bow_bow_aim")
            minetest.sound_play(("aom_bow_shoot"), {
                gain = 0.9,
                object = player,
                max_hear_distance = 50,
                pitch = (math.random()*0.1) + 0.90
            })
            meta:set_string("wield_image", "aom_bow_0.png")
            meta:set_string("inventory_image", "aom_bow_0.png")
        end
        return itemstack
    end,
    _cooldown = 0,
    _windup = 1.2,
    _prj_speed = 45,
    _prj_inaccuracy = 0.005,
})

aom_tcraft.register_craft({
    output = "aom_bow:bow",
    items = {
        ["aom_items:stick"] = 4,
        ["aom_items:plant_fibre"] = 10,
    }
})
