local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

core.register_tool("aom_machines:welder", {
    description = S("Block Welder"),
    _tt_color = 5,
    _tt_long_desc = S("Glues two nodes together, so that when one moves, so does its neighbor."),
    _tt_how_to_use = S("[place] to remove connections") .. "\n" ..
        S("[dig] to make a node hold onto the next node selected"),
    inventory_image = "aom_wire_welder.png",
    groups = { welder = 1, wire = 1, },
    range = 6,
    on_use = aom_wire.welder.on_use,
    on_place = aom_wire.welder.on_place,
    on_secondary_use = aom_wire.welder.on_secondary_use,
    _on_step = aom_wire.welder.on_step,
    _on_select = aom_wire.welder.on_select,
    _on_deselect = aom_wire.welder.on_deselect,
    _max_wear = 256,
})

if aom_machines.has_aom_tcraft then
    aom_tcraft.register_craft({
        output = "aom_machines:welder",
        items = {
            ["aom_items:iron_bar"] = 5,
        },
    })
end
