local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

aom_wire = {}

has_aom_settings = core.get_modpath("aom_settings") ~= nil
if has_aom_settings then
    -- TL: setting description
    aom_settings.register_setting("wire_max_movable_nodes", 100, S("Max movable nodes in contraptions"), "server")
end
-- interface with aom_settings
function aom_wire.get_setting(player, key, default)
    if has_aom_settings and (aom_settings.registered_settings[key] ~= nil) then
        local set = aom_settings.get_setting(player, key, default)
        if set ~= nil then return set end
        return default
    else
        local set = aom_item_entity.settings[key]
        if set ~= nil then return set end
        return default
    end
end

dofile(mod_path .. "/api.lua")
dofile(mod_path .. "/button.lua")
dofile(mod_path .. "/wirecutter.lua")
dofile(mod_path .. "/node_movement.lua")
