local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local flower_box = {
    type = "fixed",
    fixed = {
        -2/16, -8/16, -2/16,
        2/16, 4/16, 2/16,
    }
}

function aom_flora.register_flower(name, color, node_name)
    node_name = node_name or string.lower(name)
    minetest.register_node('aom_flora:flower_'..node_name, {
        -- TL: @1 is name of flower ("Rose")
        description = S("@1 Flower", name),
        drawtype = "plantlike",
        waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        param2 = 8,
        inventory_image = "aom_flower_"..node_name..".png",
        wield_image = "aom_flower_"..node_name..".png",
        walkable = false,
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = flower_box,
        groups = { nature = 1, attached_node = 1, ["item_flower_"..node_name] = 1,
            item_burns = 1, flower = 1, dig_immediate = 3, flora = 1, decoration = 1, },
        tiles = {"aom_flower_"..node_name..".png"},
        sounds = aom_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
        on_construct = function(pos)
            local node = minetest.get_node(pos)
            node.param2 = 8 -- this makes it randomly offset horizontally
            minetest.swap_node(pos, node, true)
        end,
    })
end

-- TL: name of flower plant
aom_flora.register_flower(S("Daisy"), "white", "white")
-- TL: name of flower plant
aom_flora.register_flower(S("Rose"), "red", "red")
-- TL: name of flower plant
aom_flora.register_flower(S("Bear's Ear"), "yellow", "yellow")

