


local vmax = aom_underworld.alt_max - 50
local vmin = aom_underworld.alt_min


if true then
  local size = 1000
  local undulation_size = 100
  local scale = 40
  local thick_scale = 30
  local thickness = 70
  ---------------------------------------------------------
  -- caverns
  ---------------------------------------------------------
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "air",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax + 200,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmax,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = thick_scale,
      spread = {x = undulation_size, y = undulation_size, z = undulation_size},
      seed = 8976 * 276,
      octaves = 3,
      persistence = 0.7
    },
    biomes = {},
  })
  ---------------------------------------------------------
  -- ceiling
  ---------------------------------------------------------
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_ceiling",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax + 200,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmax + aom_underworld.ceiling,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = thick_scale,
      spread = {x = undulation_size, y = undulation_size, z = undulation_size},
      seed = 8976 * 276,
      octaves = 3,
      persistence = 0.7
    },
    biomes = {},
  })
  minetest.register_ore({
    ore_type       = "scatter",
    ore            = "aom_underworld:glow_rock",
    wherein        = {"aom_underworld:worknode_ceiling"},
    y_min = aom_underworld.alt_max,
    y_max = aom_underworld.alt_max + 200,
    clust_scarcity = 800,
    clust_num_ores = 4,
    clust_size     = 2,
  })
  ---------------------------------------------------------
  -- soil
  ---------------------------------------------------------
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_soil",
    wherein        = {"group:solid", "group:liquid", "group:stone"},
    y_min = vmin,
    y_max = vmax + 200,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmax - aom_underworld.soil,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = thick_scale,
      spread = {x = undulation_size, y = undulation_size, z = undulation_size},
      seed = 8976 * 276,
      octaves = 3,
      persistence = 0.7
    },
    biomes = {},
  })
  ---------------------------------------------------------
  -- topsoil
  ---------------------------------------------------------
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_topsoil",
    wherein        = {"aom_underworld:worknode_soil"},
    y_min = vmin,
    y_max = vmax + 200,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmax - aom_underworld.topsoil,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = thick_scale,
      spread = {x = undulation_size, y = undulation_size, z = undulation_size},
      seed = 8976 * 276,
      octaves = 3,
      persistence = 0.7
    },
    biomes = {},
  })
  ---------------------------------------------------------
  -- dust
  ---------------------------------------------------------
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_underworld:worknode_dust",
    wherein        = {"aom_underworld:worknode_topsoil"},
    y_min = vmin,
    y_max = vmax + 200,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmax - aom_underworld.dust,
      scale = scale,
      spread = {x = size, y = size, z = size},
      seed = 559,
      octaves = 5,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = thick_scale,
      spread = {x = undulation_size, y = undulation_size, z = undulation_size},
      seed = 8976 * 276,
      octaves = 3,
      persistence = 0.7
    },
    biomes = {},
  })
end