
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'tundra'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:grass_snow',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    -- node_water_top = "aom_soil:snow",
    -- depth_water_top = 1,

    y_max = alt_max,
    y_min = sealevel + 1,
    vertical_blend = 1,

    heat_point = 8,
    humidity_point = 38,
}, {"cold", "ash", "overworld"})


-- also register a lower version
aom_biomes.register_biome({
    name = this_biome.."_shore",

    node_top = 'aom_soil:sand',
    depth_top = 1,

    node_filler = 'aom_soil:sand',
    depth_filler = 2,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    node_water_top = "aom_liquids:ice",
    depth_water_top = 1,

    y_max = sealevel,
    y_min = sealevel - 80,
    vertical_blend = 0,

    heat_point = 8,
    humidity_point = 38,
}, {"cold", "spruce", "overworld", "shore"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path



-- lots of bunched up trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0,
        scale = 0.0095,
        spread = {x = 500, y = 200, z = 500},
        seed = 354,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_h9_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- GIANT ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.001,
        scale = 0.0055,
        spread = {x = 100, y = 100, z = 100},
        seed = 28,
        octaves = 4,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_h9_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.004,
        scale = 0.0075,
        spread = {x = 100, y = 100, z = 100},
        seed = 71,
        octaves = 4,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_h9_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- bush
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.0004,
        scale = 0.0075,
        spread = {x = 100, y = 100, z = 100},
        seed = 4,
        octaves = 4,
        persistence = 0.2,
        lacunarity = 1.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})

-- bush
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = -0.0004,
        scale = 0.0075,
        spread = {x = 100, y = 100, z = 100},
        seed = 98067,
        octaves = 4,
        persistence = 0.2,
        lacunarity = 1.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_h15_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


