
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min


minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:gravel",
    wherein		= {"group:stone", "aom_soil:dirt"},
    clust_scarcity	= 550,
    clust_num_ores	= 10,
    clust_size	= 5,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = 80, y = 80, z = 80},
        seed = 64758,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_min		= alt_min,
    y_max		= alt_max,
    biomes = aom_biomes.registered,
})
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:dirt",
    wherein		= {"aom_stone:stone"},
    clust_scarcity	= 550,
    clust_num_ores	= 10,
    clust_size	= 8,
    noise_params = {
        offset = -0.05,
        scale = 1,
        spread = {x = 80, y = 80, z = 80},
        seed = 654,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    y_min		= alt_min,
    y_max		= alt_max,
    biomes = aom_biomes.registered,
})

minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_soil:clay",
    wherein        = {"aom_soil:sand"},
    y_min = sealevel - 40,
    y_max = sealevel - 1,
    clust_scarcity  = 1,
    noise_params    = {
        offset = sealevel - 15,
        scale = 60,
        spread = {x = 20, y = 20, z = 20},
        seed = 5937,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 5,
        scale = 30,
        spread = {x = 10, y = 10, z = 10},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    -- biomes = aom_biomes.shore,
})
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "aom_soil:gravel",
    wherein        = {"aom_soil:sand"},
    y_min = sealevel - 40,
    y_max = sealevel - 0,
    clust_scarcity  = 1,
    noise_params    = {
        offset = sealevel - 15,
        scale = 100,
        spread = {x = 90, y = 90, z = 90},
        seed = 7654,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = -5,
        scale = 40,
        spread = {x = 30, y = 30, z = 30},
        seed = 3428,
        octaves = 4,
        persistence = 0.2
    },
    -- biomes = aom_biomes.shore,
})



minetest.register_ore({
    ore_type	= "blob",
    ore		    = "aom_stone:granite",
    wherein		= {"group:stone"},
    clust_scarcity	= 50050,
    clust_num_ores	= 40,
    clust_size	= 60,
    noise_params = {
        offset  = -1.1,
        scale   = 1.4,
        spread  = {x=800, y=800, z=800},
        seed    = 765,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    y_min		= alt_min,
    y_max		= alt_max,
    -- biomes = aom_biomes.registered,
})

minetest.register_ore({
    ore_type	= "blob",
    -- ore		    = "aom_underworld:glow_rock",
    ore		    = "aom_stone:limestone",
    wherein		= {"group:stone"},
    clust_scarcity	= 50000,
    clust_num_ores	= 40,
    clust_size	= 70,
    noise_params = {
        offset  = -1.1,
        scale   = 1.4,
        spread  = {x=800, y=800, z=800},
        seed    = 765,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    y_min		= alt_min,
    y_max		= alt_max,
    -- biomes = aom_biomes.registered,
})
