local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

local mushroom_box = {
    type = "fixed",
    fixed = {
        -2/16, -8/16, -2/16,
        2/16, 4/16, 2/16,
    }
}


function aom_flora.register_mushroom(name, params)
    if not params then params = {} end
    local node_name = string.lower(name)
    core.register_node('aom_flora:mushroom_'..node_name, {
        -- TL: @1 is type of mushroom ("Brown")
        description = S("@1 Mushroom", name),
        drawtype = "plantlike",
        walkable = false,
        -- waving = 1,
        paramtype = "light",
        paramtype2 = "meshoptions",
        inventory_image = "aom_mushroom_"..node_name..".png",
        wield_image = "aom_mushroom_"..node_name..".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = mushroom_box,
        groups = { nature = 1, attached_node = 1, ["item_mushroom_"..node_name] = 1,
            snappy = 3, dig_immediate = 3, flora = 1, mushroom = 1, player_place_only = 1, item_burns = 1, decoration = 1, },
        tiles = {"aom_mushroom_"..node_name..".png"},
        sounds = aom_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, params.placeable_on or {"soil"})
        end,
        on_construct = function(pos)
            local node = core.get_node(pos)
            node.param2 = 8 -- this makes it randomly offset horizontally
            core.swap_node(pos, node, true)
        end,
    })
end

aom_flora.register_mushroom("Brown")
aom_flora.register_mushroom("Red")
aom_flora.register_mushroom("White")

aom_util.register_wield_use_delay("aom_flora:mushroom_red", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["poison_3"] = 9+1,
        ["woozy"] = 2,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_white", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["poison_3"] = 9+1,
        ["featherfalling"] = 2,
    })
})
aom_util.register_wield_use_delay("aom_flora:mushroom_brown", {
    windup = 2,
    sound = aom_food.sound.munch({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_8"] = 8+1,
    })
})

-- grow mushrooms
local mushroom_searchsize = vector.new(3,2,3)
core.register_abm({
    nodenames = {'group:mushroom'},
    interval = 30.0,
    chance = 50,
    action = function(pos, node, active_object_count, active_object_count_wider)
        aom_util.did_abm("mushroom")

        local light = core.get_node_light(pos, 0.5)
        if light > 8 then return false end

        local sp1 = vector.subtract(pos, mushroom_searchsize)
        local sp2 = vector.add(pos, mushroom_searchsize)

        local mushrooms = core.find_nodes_in_area(sp1, sp2, node.name)
        if #mushrooms > 6 then return end

        sp1.y = sp1.y - 1
        local nodes = core.find_nodes_in_area_under_air(sp1, sp2, "group:soil")
        local index = math.random(1, #nodes -1)
        if not nodes[index] then return end
        local place_pos = vector.offset(nodes[index], 0, 1, 0)
        if core.get_node(place_pos).name == "air" then
            core.set_node(place_pos, {name=node.name})
        end
    end,
})

