
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'grasslands'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:dirt_with_grass',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 200,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 49,
    humidity_point = 46,
}, {"field", "overworld", "clearing", "flowers", "grass"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

local size = 100
-- GRASS VAR 4
core.register_ore({
        ore_type	= "stratum",
        ore		    = "aom_soil:grass_variant_4",
        wherein		= {"group:topsoil"},
        y_min = sealevel-20,
        y_max = sealevel+200,
        clust_scarcity    = 1,
        noise_params        = {
                offset = sealevel+10,
                scale = 200,
                spread = {x = size, y = size, z = size},
                seed = 354387,
                octaves = 3,
                lacunarity = 3,
        },
        np_stratum_thickness = {
                offset = -20,
                scale = 250,
                spread = {x = 100, y = 100, z = 100},
                seed = 89567864,
                octaves = 2,
                lacunarity = 3,
                persistence = 0.2
        },
        stratum_thickness = 20,
        biomes = {this_biome},
})


local tree_np = {
    offset = -0.0015,
    scale = 0.003,
    spread = {x = 16, y = 16, z = 16},
    seed = 5546,
    octaves = 2,
    persist = 0.2,
    lucanarity = 2.78,
}
-- huge oak
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h23_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 33,
})
-- huge oak
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h10_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 36,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

-- sparse trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h14_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

-- sparse trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h10_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 36,
})


local bush_np = {
    offset = -0.0015,
    scale = 0.005,
    spread = {x = 16, y = 16, z = 16},
    seed = 10843,
    octaves = 1,
    persist = 0.2,
    lucanarity = 2.78,
}
-- bushes in large sparse clumps
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 4,
    noise_params = bush_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 4,
    noise_params = bush_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})
core.register_decoration({
    deco_type = "simple",
    place_on = {"group:soil"},
    sidelen = 4,
    noise_params = bush_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "aom_flora:shrub_1",
    _layer = 44,
})
-- huge oak
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 8,
    noise_params = tree_np,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})

