
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'oak_forest_dense'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:forest_dirt',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 80,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 87,
    humidity_point = 90,
}, {"forest", "oak", "overworld", "mushrooms"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path

-- FOREST GRASS
core.register_ore({
    ore_type	= "blob",
    ore		    = "aom_soil:forest_grass",
    wherein		= {"aom_soil:forest_dirt"},
    clust_scarcity	= 150,
    clust_num_ores	= 5,
    clust_size	= 6,
    y_max = alt_max,
    y_min = sealevel,
    noise_params = {
    offset  = 0.3,
    scale   = 0.1,
    spread  = {x=50, y=50, z=50},
    seed    = 12345,
    octaves = 3,
    persist = 0.6,
    lacunarity = 2,
    flags = "defaults",
    },
    biomes = {this_biome},
})


if true then
-- lots of bunched up trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
    offset = 0,
    scale = 0.02,
    spread = {x = 15, y = 150, z = 15},
    seed = 96,
    octaves = 2,
    persist = 0.1
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h14_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})


-- bushes in large sparse clumps
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
    offset = -0.001,
    scale = 0.01,
    spread = {x = 25, y = 250, z = 25},
    seed = 3,
    octaves = 2,
    persist = 0.6
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
    _layer = 39,
})

-- GIANT oaks
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.007,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h23_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})
-- GIANT oaks
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h19_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -0,
    _layer = 34,
})
-- really huge tree
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.004,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h23_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -5,
    _layer = 34,
})
-- GIANT oaks
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.007,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h12_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})
-- smaller trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h10_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
    _layer = 36,
})
-- smaller trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_small_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
    _layer = 35,
})
-- smaller trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_small_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
    _layer = 35,
})
-- smaller trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.01,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_oak_h14_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 0,
    _layer = 35,
})

-- lots of bunched up trees
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
    offset = 0,
    scale = 0.015,
    spread = {x = 500, y = 200, z = 500},
    seed = 354,
    octaves = 2,
    persistence = 0.7,
    lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_ash_h12_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 35,
})

end
