
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'taiga_tall_dense'

aom_biomes.register_biome({
    name = this_biome,

    node_top = 'aom_soil:forest_dirt',
    depth_top = 1,

    node_filler = 'aom_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'aom_soil:sand',
    depth_riverbed = 3,

    -- node_water_top = "aom_soil:snow",
    -- depth_water_top = 1,

    y_max = alt_max,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 18,
    humidity_point = 86,
}, {"spruce", "overworld"})


-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = aom_sch.get_schematic_path


local size = 20
core.register_ore({
    ore_type	= "stratum",
    ore		        = "aom_stone:cobble",
    wherein		= {"group:soil"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 80,
        scale = 10,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
core.register_ore({
    ore_type	= "stratum",
    ore		        = "aom_stone:cobble_moss_1",
    wherein		= {"aom_stone:cobble"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 50,
        scale = 10,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
core.register_ore({
    ore_type	= "stratum",
    ore		        = "aom_stone:cobble_moss_2",
    wherein		= {"aom_stone:cobble_moss_1"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5643,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 30,
        scale = 10,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
core.register_ore({
    ore_type	= "stratum",
    ore		        = "aom_stone:cobble",
    wherein		= {"aom_stone:cobble_moss_1", "aom_stone:cobble_moss_2"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 654987,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 180,
        scale = 10,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})
core.register_ore({
    ore_type	= "stratum",
    ore		        = "aom_stone:stone",
    wherein		= {"aom_stone:cobble_moss_2"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 432,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 180,
        scale = 10,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})


size = 200
core.register_ore({
    ore_type	= "stratum",
    ore		        = "aom_soil:gravel",
    wherein		= {"group:soil"},
    y_min = sealevel-20,
    y_max = sealevel+200,
    clust_scarcity    = 1,
    noise_params        = {
        offset = sealevel+10,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 765,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = 20,
        scale = 250,
        spread = {x = 20, y = 20, z = 20},
        seed = 453,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome},
})


core.register_ore({
    ore_type	= "scatter",
    ore		        = "aom_soil:forest_grass",
    wherein		= {"aom_soil:forest_dirt"},
    clust_scarcity	= 100,
    clust_num_ores	= 6,
    clust_size	= 4,
    y_max = alt_max,
    y_min = alt_min,
    biomes = {this_biome},
})


if true then
-- GIANT HUGE DAMN SPRUCE TREES
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.003,
        scale = 0.0005,
        spread = {x = 500, y = 200, z = 500},
        seed = 987,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_w2h49_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 30,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.006,
        scale = 0.0001,
        spread = {x = 5, y = 5, z = 5},
        seed = 7654,
        octaves = 12,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_w2h37_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 31,
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.01,
        scale = 0.0001,
        spread = {x = 5, y = 5, z = 5},
        seed = 876,
        octaves = 1,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h28_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 32,
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    noise_params = {
        offset = 0.005,
        scale = 0.002,
        spread = {x = 5, y = 5, z = 5},
        seed = 234,
        octaves = 3,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h25_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 33,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.018,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h23_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 33,
})
core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.018,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h20_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.015,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("aom_tree_spruce_tall_h20_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    _layer = 34,
})

end

