

local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min

local size = 10



local function do_potato_stuff(num, seed)
    core.register_decoration({
        -- name = "aom_flora:flax_"..num,
        deco_type = "simple",
        place_on = {"group:soil"}, -- only on grasslike nodes
        sidelen = 2,
        noise_params = {
            offset = -2.1 - num*0.02,
            scale = 2.1,
            spread = {x = size, y = size, z = size},
            seed = seed,
            octaves = 3,
            persist = 0.1
        },
        biomes = {"grasslands", "grasslands_valley"},
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "aom_flora:potato_"..num,
        _layer = 46,
    })
end


do_potato_stuff(0, 7852)
do_potato_stuff(1, 7852)
do_potato_stuff(2, 7852)


--mix with grass

local function do_grass_stuff(num, seed)
    core.register_decoration({
        -- name = "aom_flora:grass_"..num.."_for_flax",
        deco_type = "simple",
        place_on = {"group:solid"}, -- only on grasslike nodes
        sidelen = 2,
        noise_params = {
            offset = -1.6 + num*0.05,
            scale = 1.8,
            spread = {x = size, y = size, z = size},
            seed = seed,
            octaves = 2,
            persist = 0.2
        },
        biomes = {"grasslands", "grasslands_valley"},
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "aom_flora:grass_"..num,
        _layer = 46,
    })
end


do_grass_stuff(0, 7852)
do_grass_stuff(1, 7852)
