local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local grass_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, 2/16, 6/16,
    }
}

local np = {
    offset = 0.5,
    scale = 0.5,
    spread = {x = 2, y = 2, z = 2},
    seed = 54256,
    octaves = 2,
    persist = 0.01,
    lacunarity = 2.317,
}

local iperlin = PerlinNoise(np)

-- aom_flora:grass_0 --> aom_flora:grass_3
local function register_grass(node_name, tiles)
    local name = string.lower(node_name)
    core.register_node("aom_flora:" .. name, {
        -- TL: ground cover grass plant
        description = S("Grass"),
        drawtype = "plantlike",
        walkable = false,
        waving = 1,
        paramtype = "light",
        -- paramtype2 = "degrotate",
        paramtype2 = "meshoptions",
        param2 = 3 + 8 + 16 + 32,
        inventory_image = "aom_" .. name .. ".png",
        wield_image = "aom_" .. name .. ".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = grass_box,
        groups = { nature = 1, attached_node = 1, item_burns = 1, grass = 1, dig_immediate = 3, flora = 1, decoration = 1, },
        drop = aom_flora.grass_drops,
        tiles = tiles,
        buildable_to = true,
        sounds = aom_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
        after_generated = function(pos)
            local f = math.min(0.9999, math.max(0.0001, (iperlin:get_3d(pos))))
            core.swap_node(pos, {
                name = "aom_flora:" .. name,
                param2 = math.floor(f * 3) + 8 + 32 + (math.floor(f * 2)*16)
            })
        end,
    })
end

register_grass("grass_0", {"aom_grass_0.png"})
register_grass("grass_1", {"aom_grass_1.png"})
register_grass("grass_2", {"aom_grass_2.png"})
register_grass("grass_3", {"aom_grass_3.png"})
