local S = core.get_translator(core.get_current_modname())

aom_trees.grow_tree = {}

aom_trees.schematics = {}

function aom_trees.register_sapling(name)
    local node_name = string.lower(name)
    aom_trees.grow_tree[node_name] = aom_trees.grow_tree[node_name] or function() return nil end

    minetest.register_node(("aom_trees:" .. node_name .. "_sapling"), {
        description = S("@1 Sapling", name),
        drawtype = "plantlike",
        waving = 1,
        visual_scale = 1.0,
        tiles = {"aom_sapling_" .. node_name .. ".png"},
        inventory_image = "aom_sapling_" .. node_name .. ".png",
        wield_image = "aom_sapling_" .. node_name .. ".png",
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        buildable_to = true,
        groups = { nature = 1, ["item_"..node_name.."_sapling"] = 1, attached_node = 1, player_place_only = 1, dig_immediate = 3, sapling = 1,},
        -- drop = {"aom_trees:" .. node_name .. "_sapling"},
        -- sounds = {},
        selection_box = {
            type = "fixed",
            fixed = {-5/16, -8/16, -5/16, 5/16, 1/16, 5/16},
        },
        is_ground_content = true,
        _tree_type = node_name,
        _tree_grow = function(pos, node)
            if type(aom_trees.grow_tree[name]) == "function" then
                aom_trees.grow_tree[name](pos, node)
            else
                aom_trees.grow_tree.general(pos, node_name)
            end
        end,
        on_place = function(itemstack, placer, pointed_thing)
            return aom_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
    })
end

aom_trees.register_sapling("Oak")
aom_trees.register_sapling("Ash")
aom_trees.register_sapling("Spruce")


-- schematics and growing trees
local sch = aom_sch.get_schematic_path

function aom_trees.register_tree_schematic(kind, name)
    aom_trees.schematics[kind] = aom_trees.schematics[kind] or {}
    aom_trees.schematics[kind][#aom_trees.schematics[kind]+1] = sch(name)
end

-- OAK
aom_trees.register_tree_schematic("oak", "aom_tree_oak_h10_0")
aom_trees.register_tree_schematic("oak", "aom_tree_oak_h12_0")
aom_trees.register_tree_schematic("oak", "aom_tree_oak_h14_0")
aom_trees.register_tree_schematic("oak", "aom_tree_oak_h12_1")
aom_trees.register_tree_schematic("oak", "aom_tree_oak_h19_0")
aom_trees.register_tree_schematic("oak", "aom_tree_oak_h23_0")

-- ASH
aom_trees.register_tree_schematic("ash", "aom_tree_ash_h12_0")
aom_trees.register_tree_schematic("ash", "aom_tree_ash_h15_0")
aom_trees.register_tree_schematic("ash", "aom_tree_ash_h18_0")
aom_trees.register_tree_schematic("ash", "aom_tree_ash_h19_0")
aom_trees.register_tree_schematic("ash", "aom_tree_ash_h31_0")

-- SPRUCE
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_h9_0")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_h9_1")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_h9_2")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_tall_h28_0")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_tall_h25_0")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_tall_h23_0")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_tall_h20_0")
aom_trees.register_tree_schematic("spruce", "aom_tree_spruce_tall_h18_0")


function aom_trees.grow_tree.general(pos, name)
    minetest.set_node(pos, {name = "air"})

    if not aom_trees.schematics[name] then
        minetest.log("error", "Warning, unable to place sapling type " .. tostring(name) .. " at " .. dump(pos))
        return end
    local variant = math.random(1, #aom_trees.schematics[name])
    variant = aom_trees.schematics[name][variant]
    minetest.place_schematic(pos, variant, "random", nil, false, {place_center_x=true, place_center_z=true})
end
