
local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.sea_level + 40
local alt_min = aom_vars.overworld.sea_level + 1

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "desert_dunes"

aom_biomes.register_biome({
    name = this_biome,

    node_top = "aom_soil:sand",
    depth_top = 5,

    -- node_dust = "aom_soil:clay",
    -- depth_dust = 1,

    node_filler = "aom_stone:sandstone",
    depth_filler = 15,

    node_riverbed = "aom_soil:sand",
    depth_riverbed = 3,

    y_max = alt_max,
    y_min = alt_min,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 100,
    humidity_point = 0,
}, {"desert", "overworld"})

local sch = aom_sch.get_schematic_path

-------------------------------
--------- DECORATIONS ---------
-------------------------------

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:sand"},
    sidelen = 80,
    noise_params = {
        offset    = 0,
        scale     = 0.0001,
        spread    = {x=3, y=3, z=3},
        seed      = 7852,
        octaves   = 4,
        persist   = 1,
        lacunarity= 1,
        flags = "defaults",
    },
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("aom_boulder_0"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:sand"},
    sidelen = 80,
    noise_params = {
        offset    = 0,
        scale     = 0.0001,
        spread    = {x=3, y=3, z=3},
        seed      = 87,
        octaves   = 4,
        persist   = 1,
        lacunarity= 1,
        flags = "defaults",
    },
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("aom_boulder_1"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"aom_soil:sand"},
    sidelen = 80,
    noise_params = {
        offset    = 0,
        scale     = 0.0001,
        spread    = {x=3, y=3, z=3},
        seed      = 7852,
        octaves   = 4,
        persist   = 1,
        lacunarity= 1,
        flags = "defaults",
    },
    biomes = {this_biome},
    y_min = -10,
    y_max = 200,
    schematic = sch("aom_boulder_2"),
    flags = "place_center_x, place_center_z, force_placement",
    rotation = "random",
    place_offset_y = -2
})
