
local adjacent = {
    vector.new( 0, 1, 0),
    vector.new( 0,-1, 0),
    vector.new( 0, 0, 1),
    vector.new( 0, 0,-1),
    vector.new( 1, 0, 0),
    vector.new(-1, 0, 0),
}

function aom_fluidapi.get_liquid_flow_direction(pos, source)
    local dir = vector.new(0,0,0)
    local node = core.get_node(pos)
    if node.param2 >= 8 then node.param2 = 0 end
    for i = 3, #adjacent do
        local d = adjacent[i]
        local n = core.get_node(pos + d)
        if n.param2 >= 8 then n.param2 = 0 end
        local ndef = core.registered_nodes[n.name]
        if not ndef then return dir end
        if ndef.liquidtype == "flowing" then
            if n.param2 < ((source and 8) or node.param2) then
                dir = dir + d
            elseif n.param2 > ((source and 8) or node.param2) then
                dir = dir - d
            end
        end
    end
    return vector.normalize(dir)
end

function aom_fluidapi.push_by_liquid(object, dtime, strength)
    local pos = object:get_pos()
    local node = core.get_node(pos)
    local ndef = core.registered_nodes[node.name]
    if not ndef then return end
    if (ndef.liquidtype == "flowing") or (ndef.liquidtype == "source") then
        local dir = aom_fluidapi.get_liquid_flow_direction(pos, (ndef.liquidtype == "source"))
        if dir:equals(vector.new(0,0,0)) then return end
        local vel = (dir * strength)
        local rvel = object:get_velocity()
        local dist = vector.length(vel) - vector.length(rvel)
        dist = (dist + vector.distance(vel, rvel)) / 2
        vel = vel * (dist)
        object:add_velocity(vel * (dtime))
        return true
    end
end
