local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

core.register_craftitem("aom_food:wooden_bowl_mushroom_soup", {
    description = S("Mushroom Soup"),
    inventory_image = "aom_wooden_bowl.png^aom_mushroom_soup.png",
    groups = { item_wooden_bowl_mushroom_soup = 1, craftitem = 1, soup = 1, food = 1, },
})
aom_util.register_wield_use_delay("aom_food:wooden_bowl_mushroom_soup", {
    windup = 2,
    sound = aom_food.sound.gulp({gain=0.2}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_1"] = 4,
        ["regeneration_3"] = 3*8+1,
        ["regeneration_8"] = 4*8+1,
    }, "aom_items:wooden_bowl", aom_food.sound.gulp())
})

aom_tcraft.register_craft({
    output = "aom_food:wooden_bowl_mushroom_soup",
    items = {
        ["aom_items:wooden_bowl"] = 1,
        ["aom_flora:mushroom_white"] = 1,
        ["aom_flora:mushroom_red"] = 1,
    }
})
aom_tcraft.register_craft({
    output = "aom_food:wooden_bowl_mushroom_soup",
    items = {
        ["aom_items:wooden_bowl"] = 1,
        ["aom_flora:mushroom_white"] = 1,
        ["aom_flora:mushroom_brown"] = 1,
    }
})
aom_tcraft.register_craft({
    output = "aom_food:wooden_bowl_mushroom_soup",
    items = {
        ["aom_items:wooden_bowl"] = 1,
        ["aom_flora:mushroom_brown"] = 1,
        ["aom_flora:mushroom_red"] = 1,
    }
})

core.register_alias("pmb_items:wooden_bowl_mushroom_soup", "aom_food:wooden_bowl_mushroom_soup")


-- pumpkin soup
core.register_craftitem("aom_food:wooden_bowl_pumpkin_soup", {
    description = S("Pumpkin Soup"),
    inventory_image = "aom_wooden_bowl.png^aom_pumpkin_soup.png",
    groups = { item_wooden_bowl_pumpkin_soup = 1, craftitem = 1, soup = 1, food = 1, },
})
aom_util.register_wield_use_delay("aom_food:wooden_bowl_pumpkin_soup", {
    windup = 2,
    sound = aom_food.sound.gulp({gain=0.8}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_3"] = 3*8+1,
        ["regeneration_8"] = 4*8+1,
    }, "aom_items:wooden_bowl", aom_food.sound.gulp())
})
aom_tcraft.register_craft({
    output = "aom_food:wooden_bowl_pumpkin_soup",
    items = {
        ["aom_items:wooden_bowl"] = 1,
        ["aom_food:pumpkin_cooked"] = 1,
    }
})


core.register_craftitem("aom_food:glowroot_soup", {
    description = S("Glowroot Soup"),
    inventory_image = "aom_wooden_bowl.png^aom_glowroot_soup.png",
    groups = { item_baked_potato = 1, craftitem = 1, food = 1, potion = 1, },
})
aom_util.register_wield_use_delay("aom_food:glowroot_soup", {
    windup = 2,
    sound = aom_food.sound.gulp({gain=0.8}),
    sound_per_sec = 2,
    on_use = aom_food.eat({
        ["regeneration_8"] = 8*4+1,
        ["glowing_12"] = 120,
    }, "aom_items:wooden_bowl", aom_food.sound.gulp({gain=0.8}))
})

aom_tcraft.register_craft({
    output = "aom_food:glowroot_soup",
    extra_items = {
        "aom_items:wooden_cup",
    },
    items = {
        ["aom_items:wooden_bowl"] = 1,
        ["aom_items:wooden_cup_water"] = 1,
        ["aom_flora:glowroot"] = 1,
    }
})
