local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

aom_igm.menu_header_image_fs = "image[3.6,0.2;4.8,2.0;"

-- adds the usual default vals to the formspec
function aom_igm.add_formspec_defaults(fs)
    table.insert(fs, "formspec_version[6]")
    table.insert(fs, "size[12.00,12.0]")
    table.insert(fs, "no_prepend[]")
    table.insert(fs, "listcolors[#00000000;#00000000;#00000000;#111;#eee]")
    table.insert(fs, "bgcolor[#00000000]")
    -- table.insert(fs, "bgcolor[#000000a0]")
    table.insert(fs, "style_type[item_image_button;bgcolor=#fff;bgcolor_hovered=#fff;bgcolor_pressed=#fff]")
    table.insert(fs, "style_type[item_image_button;textcolor=#8c3f5d;border=false]")
    table.insert(fs, "style_type[button;bgimg=aom_inv_btn.png\\^\\[multiply:#616161;bgimg_middle=8;"..
    "bgimg_hovered=aom_inv_btn.png\\^\\[multiply:#616161;bgimg_pressed=aom_inv_btn_press.png\\^\\[multiply:#616161;"..
    "bgcolor_hovered=#eee;bgcolor_pressed=#fff]".."style_type[button;border=false]")
end

local has_settings = core.get_modpath("aom_settings") ~= nil
function aom_igm.get_setting(player, name, default)
    if has_settings then return aom_settings.get_setting(player, name) or default
    else return default end
end

function aom_igm.do_sound_click(player, sound)
    core.sound_play((sound), {
        gain = 1 * aom_igm.get_setting(player, "sound_menu_volume", 1),
        to_player = player:get_player_name(),
    })
end


-- MAIN MENU
aom_igm.register_page_process("main", function(fs, player, pagename, data)
    aom_igm.add_formspec_defaults(fs)
    local headerimage = aom_igm.menu_header_image or "blank.png"
    -- main menu title
    table.insert(fs, "box[4,0;4,12;#111111e0]")
    table.insert(fs, "label[5.2,2.4;" .. S("Player Menu") .. "]")
    table.insert(fs, aom_igm.menu_header_image_fs..headerimage.."]")

    table.insert(fs, "container[6,3]")
    local buttons = aom_igm.get_formspec(player, "main_buttons")
    table.insert(fs, buttons or "")
    table.insert(fs, "container_end[]")
end)

