local builtin_item = core.registered_entities["__builtin:item"]

-- allow adding staticdata vars to load and save
aom_item_entity.staticdata_load_list = {"itemstring", "age", "dropped_by", "_sleep_state"}

local new_item_ent = {
	initial_properties = {
		physical = true,
		collide_with_objects = false,
		collisionbox = {-0.3, -0.3, -0.3, 0.3, 0.3, 0.3},
		visual = "wielditem",
		visual_size = {x = 0.3, y = 0.3},
		textures = {""},
		is_visible = false,
	},
	itemstring = "",
	moving_state = true,
	physical_state = true,
	age = 0,
	force_out = nil,
	force_out_start = nil,

    _override_physics = true,
    _sleep_state = false,
    _set_magnet = function(self, player)
        aom_item_entity.SIGNAL("set_magnet", self, player)
    end,
    _on_magnet = function(self, dtime)
        aom_item_entity.SIGNAL("on_magnet", self, dtime)
    end,
    _get_custom_params = function(self)
        aom_item_entity.SIGNAL("get_custom_params", self)
    end,
    set_item = function(self, item, ...)
        aom_item_entity.SIGNAL("set_item", self, item, ...)
    end,
    on_step = function(self, dtime, moveresult, ...)
        aom_item_entity.SIGNAL("on_step", self, dtime, moveresult, ...)
    end,
    on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir, damage, ...)
        aom_item_entity.SIGNAL("on_punch", self, puncher, time_from_last_punch, tool_capabilities, dir, damage, ...)
    end,
    on_activate = function(self, staticdata, dtime_s)
        aom_item_entity.SIGNAL("on_activate", self, staticdata, dtime_s)
    end,
    get_staticdata = function(self)
        local data = {}
        aom_item_entity.SIGNAL("get_staticdata", self, data)
        return core.serialize(data)
    end,
    enable_physics = function(self)
        aom_item_entity.SIGNAL("enable_physics", self)
    end,
    disable_physics = function(self)
        aom_item_entity.SIGNAL("disable_physics", self)
    end,
    try_merge_with = function(self, own_stack, object, entity, ...)
        for i, callback in ipairs(aom_item_entity.eventbus_register["try_merge_with"] or {}) do
            local ret = callback(self, own_stack, object, entity, ...)
            if ret == true then return ret end
        end
    end,
}

setmetatable(new_item_ent, { __index = builtin_item })
core.register_entity(":__builtin:item", new_item_ent)


