
function aom_item_entity.get_node_sound(self, moveresult, soundname)
    for i, collision in ipairs(moveresult.collisions or {}) do
        if (collision.type == "node") and (collision.axis == "y")
        and (collision.node_pos ~= nil) then
            local n = core.get_node(collision.node_pos)
            local ndef = core.registered_nodes[n.name]
            if ndef and ndef.sounds and ndef.sounds[soundname] then
                local spec = ndef.sounds[soundname]
                return {
                    name = spec.name,
                    pos = collision.node_pos,
                    gain = spec.gain or 1,
                    pitch = spec.pitch or 1,
                }
            end
        end
    end
end

aom_item_entity.LISTEN("on_landed", function(self, dtime, moveresult, ...)
    local sound = aom_item_entity.get(nil, "item_sound", 0.2)
    if sound <= 0.001 then return end
    local spec = aom_item_entity.get_node_sound(self, moveresult, "footstep")
    if not spec then return end
    spec.gain = spec.gain * sound
    core.sound_play(spec.name, spec)
end)
