local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local sfx = aom_statusfx.registered_status_effects
local epl = aom_statusfx.pl

aom_statusfx.hud = {}
aom_statusfx.hud.pl = {}
local pl = aom_statusfx.hud.pl

local function check_player(player)
    local pi = pl[player]
    if not pi then pi = {}; pl[player] = pi end
    return pi
end

local scale_multiplier = 0.75

function aom_statusfx.hud.make_effect(image)
    return {
        type = "image",
        scale = {x=4*scale_multiplier, y=4*scale_multiplier},
        text = image,
        position = {x=0, y=0.95},
        offset = {x=-100, y=0},
        z_index = 20
    }
end

function aom_statusfx.hud.add_hud(player, status_name)
    local pi = check_player(player)
    if not pi.stack then pi.stack = {} end

    if sfx[status_name] and sfx[status_name].hud
    and not pi.stack[status_name] then
        local def = table.copy(sfx[status_name].hud)
        def = def.text .. "^[opacity:200"

        local hud_id = COMPAT.hud_add(player, sfx[status_name].hud)
        pi.stack[status_name] = hud_id
        pi._changes_made = true
    end
end
function aom_statusfx.hud.remove_hud(player, status_name)
    local pi = check_player(player)
    if not pi.stack then pi.stack = {} end
    if not pi.stack[status_name] then return end

    player:hud_remove(pi.stack[status_name])
    pi.stack[status_name] = nil
    pi._changes_made = true
end

function aom_statusfx.hud.update_hud(player)
    local pi = check_player(player)
    if not pi.stack then pi.stack = {} end
    if pi._changes_made then
        pi._changes_made = false
        local offsetx = 40
        local offsety = 0
        local spacing = 16 * 4 * scale_multiplier + 4
        for status_name, hud_id in pairs(pi.stack) do
            player:hud_change(hud_id, "offset", {
                x = offsetx,
                y = offsety,
            })
            offsety = offsety - spacing
        end
    else
        local i = 0
        for status_name, hud_id in pairs(pi.stack) do
            local time_left = epl[player][status_name].meta.time
            local blink = epl[player][status_name].blink
            local was_blinking = epl[player][status_name].was_blinking or false

            local switch = (math.ceil(time_left * 3) % 2 == 0)

            if time_left < 5 and not blink and switch then
                epl[player][status_name].blink = true
                local image = sfx[status_name].hud and sfx[status_name].hud.text
                image = image .. "^[opacity:100"
                player:hud_change(hud_id, "text", image)

                epl[player][status_name].was_blinking = true
            elseif time_left < 5 and blink and not switch then
                epl[player][status_name].blink = false
                local image = sfx[status_name].hud and sfx[status_name].hud.text
                image = image .. "^[opacity:250"
                player:hud_change(hud_id, "text", image)

                epl[player][status_name].was_blinking = true
            elseif time_left > 5 and was_blinking then
                epl[player][status_name].blink = true
                local image = sfx[status_name].hud and sfx[status_name].hud.text
                image = image .. "^[opacity:200"
                player:hud_change(hud_id, "text", image)

                epl[player][status_name].was_blinking = false
            end
            i = i + 1
        end
    end
end


function aom_statusfx.hud.remove_all_huds(player)
    for status_name, status_data in pairs(epl[player]) do
        local stack = status_data.stack
        if stack and #stack > 0 then
            aom_statusfx.hud.remove_hud(player, status_name)
        end
    end
end


function aom_statusfx.hud.refresh_hud(player)
    if not epl[player] then return end
    for status_name, status_data in pairs(epl[player]) do
        local stack = status_data.stack
        if stack and #stack > 0 then
            aom_statusfx.hud.add_hud(player, status_name)
        end
    end
end


core.register_on_joinplayer(function(player, last_login)
    core.after(0.2, function()
        aom_statusfx.hud.refresh_hud(player)
    end)
end)



