local S = core.get_translator(core.get_current_modname())

local bar_cook_time = 3

----------------------------------
---------------BARS---------------
----------------------------------
core.register_craftitem("aom_items:iron_bar", {
    description = S("Iron bar"),
    inventory_image = "aom_iron_bar.png",
    groups = { item_iron_bar = 1, craftitem = 1, iron = 1, iron_bar = 1, },
})

core.register_craftitem("aom_items:tin_bar", {
    description = S("Tin bar"),
    inventory_image = "aom_tin_bar.png",
    groups = { item_tin_bar = 1, craftitem = 1, tin = 1, tin_bar = 1, },
})

core.register_craftitem("aom_items:copper_bar", {
    description = S("Copper bar"),
    inventory_image = "aom_copper_bar.png",
    groups = { item_copper_bar = 1, craftitem = 1, copper = 1, copper_bar = 1, },
})

core.register_craftitem("aom_items:bronze_bar", {
    description = S("Bronze bar"),
    inventory_image = "aom_bronze_bar.png",
    groups = { item_bronze_bar = 1, craftitem = 1, bronze = 1, bronze_bar = 1, },
})

core.register_craftitem("aom_items:gold_bar", {
	description = S("Gold bar"),
	inventory_image = "aom_gold_bar.png",
	groups = { item_gold_bar = 1, craftitem = 1, gold = 1, gold_bar = 1, },
})

----------------------------------
-----------BAR COOKING------------
----------------------------------

local function reg_bar_cook(name)
    aom_cooking.register_cooking({
        raw = "aom_items:" .. name .. "_nugget",
        cooked = "aom_items:" .. name .. "_bar",
        cook_time = bar_cook_time,
        groups = {"cooker_crucible"},
    })
    aom_cooking.register_cooking({
        raw = "aom_items:" .. name .. "_sheet",
        cooked = "aom_items:" .. name .. "_bar",
        cook_time = bar_cook_time,
        groups = {"cooker_crucible"},
    })
end

reg_bar_cook("iron")
reg_bar_cook("tin")
reg_bar_cook("copper")
reg_bar_cook("bronze")
reg_bar_cook("gold")

core.register_craft({
    output = "aom_items:bronze_nugget 2",
    type = "shapeless",
    recipe = { "aom_items:copper_nugget", "aom_items:tin_nugget"
    },
})

----------------------------------
--------------SHEETS--------------
----------------------------------

local sheet_cook_time = 1

core.register_craftitem("aom_items:iron_sheet", {
    description = S("Iron sheet"),
    inventory_image = "aom_iron_sheet.png",
    groups = { item_iron_sheet = 1, craftitem = 1, iron = 1, iron_sheet = 1, },
})

core.register_craftitem("aom_items:tin_sheet", {
    description = S("Tin sheet"),
    inventory_image = "aom_tin_sheet.png",
    groups = { item_tin_sheet = 1, craftitem = 1, tin = 1, tin_sheet = 1, },
})

core.register_craftitem("aom_items:copper_sheet", {
    description = S("Copper sheet"),
    inventory_image = "aom_copper_sheet.png",
    groups = { item_copper_sheet = 1, craftitem = 1, copper = 1, copper_sheet = 1, },
})

core.register_craftitem("aom_items:bronze_sheet", {
    description = S("Bronze sheet"),
    inventory_image = "aom_bronze_sheet.png",
    groups = { item_bronze_sheet = 1, craftitem = 1, bronze = 1, bronze_sheet = 1, },
})

core.register_craftitem("aom_items:gold_sheet", {
	description = S("Gold sheet"),
	inventory_image = "aom_gold_sheet.png",
	groups = { item_gold_sheet = 1, craftitem = 1, gold = 1, gold_sheet = 1, },
})

----------------------------------
---------SHEET COOKING------------
----------------------------------

aom_cooking.register_cooking({
    raw = "aom_items:iron_bar",
    cooked = "aom_items:iron_sheet",
    cook_time = sheet_cook_time,
    groups = {"anvil"},
})
aom_cooking.register_cooking({
    raw = "aom_items:tin_bar",
    cooked = "aom_items:tin_sheet",
    cook_time = sheet_cook_time,
    groups = {"anvil"},
})
aom_cooking.register_cooking({
    raw = "aom_items:copper_bar",
    cooked = "aom_items:copper_sheet",
    cook_time = sheet_cook_time,
    groups = {"anvil"},
})
aom_cooking.register_cooking({
    raw = "aom_items:bronze_bar",
    cooked = "aom_items:bronze_sheet",
    cook_time = sheet_cook_time,
    groups = {"anvil"},
})
aom_cooking.register_cooking({
  raw = "aom_items:gold_bar",
  cooked = "aom_items:gold_sheet",
  cook_time = sheet_cook_time,
  groups = {"anvil"},
})

----------------------------------
-------SHEET UN-COOKING-----------
----------------------------------

aom_cooking.register_cooking({
    raw = "aom_items:iron_sheet",
    cooked = "aom_items:iron_bar",
    cook_time = bar_cook_time,
    groups = {"cooker_crucible"},
})
aom_cooking.register_cooking({
    raw = "aom_items:tin_sheet",
    cooked = "aom_items:tin_bar",
    cook_time = bar_cook_time,
    groups = {"cooker_crucible"},
})
aom_cooking.register_cooking({
    raw = "aom_items:copper_sheet",
    cooked = "aom_items:copper_bar",
    cook_time = bar_cook_time,
    groups = {"cooker_crucible"},
})
aom_cooking.register_cooking({
    raw = "aom_items:bronze_sheet",
    cooked = "aom_items:bronze_bar",
    cook_time = bar_cook_time,
    groups = {"cooker_crucible"},
})
aom_cooking.register_cooking({
  raw = "aom_items:gold_sheet",
  cooked = "aom_items:gold_bar",
  cook_time = bar_cook_time,
  groups = {"cooker_crucible"},
})


do
    local function reg_transmute(a, c, hide)
        local ig = "aom_items:ignis"
        aom_tcraft.register_craft({
            output = a, items = {[ig] = c},
            hide_if_not_craftable = hide, tags = {"transmute"},
        })
    end
    reg_transmute("aom_items:iron_bar", 20, false)
    reg_transmute("aom_items:copper_bar", 20, false)
    reg_transmute("aom_items:tin_bar", 20, false)
    reg_transmute("aom_items:gold_bar", 40, false)
    reg_transmute("aom_items:diamond", 100, false)
    reg_transmute("aom_items:coal", 10, false)
end
