


function aom_entity_api.do_drops(self)
    if not self._drop then return nil end
    local pos = self.object:get_pos()
    if not pos then return nil end
    local max = self._drop.max_items or 9999999
    local c = 0 -- counter for items
    if self._drop.minmax then
        for _, drop in pairs(self._drop.minmax) do
            local item = drop.item
            local p = vector.offset(pos, math.random()-0.5, math.random() * 0.3+0.2, math.random()-0.5)
            local count = 1
            if drop.max then
                count = math.random(drop.min or 1, drop.max)
                count = math.max(0, count)
            end
            if count > 0 then
                local stack = ItemStack(item)
                count = math.max(0, math.min(count, max - c))
                stack:set_count(count)
                core.add_item(p, stack)
                c = c + count
                if c >= max then
                    return true
                end
            end
        end
    end
    if self._drop.items then
        for _, drop in pairs(self._drop.items) do
            local get_item = false
            get_item = get_item or (drop.chance and (math.random() < drop.chance))
            get_item = get_item or (drop.rarity and (math.random(1, drop.rarity) == 1))
            if get_item then
                for i, item in pairs(drop.items) do
                    local p = vector.offset(pos, math.random()-0.5, math.random() * 0.3+0.2, math.random()-0.5)
                    local stack = ItemStack(item)
                    core.add_item(p, stack)
                    c = c + 1
                    if c >= max then
                        return true
                    end
                end
            end
        end
    end
end
