local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local damage_groups = {
    pierce=1,
    blunt=1,
    projectile=1,
}

local function send_attack(object, target, base_damage)
    if core.get_modpath("aom_combat") then
        aom_combat.attack.send_attack(nil, object, target, {attack={
            base_damage = base_damage
        }})
    else
        target:punch(object, 1.0, {
            full_punch_interval = 1.0,
            damage_groups = base_damage
        }, nil)
    end
end

local csize = 0.3
core.register_entity("aom_kelar:rock_ENTITY", {
    initial_properties = {
        visual = "mesh",
        mesh = "aom_kelar_rock.b3d",
        textures = {"aom_kelar_rock.png"},
        stepheight = 0,
        hp_max = 1,
        physical = false,
        pointable = false,
        collisionbox = {
            -csize, -csize, -csize, csize, csize, csize,
        },
        static_save = false,
    },
    on_step = function(self, dtime)
        if self._age > 10 then
            self.object:remove()
        end
        self._tsound = (self._tsound or 0) + dtime
        if self._tsound > 0.5 then
            self._tsound = 0
            if self._aom_sound_id then
                core.sound_fade(self._aom_sound_id, 1, 0)
            end
            self._aom_sound_id = core.sound_play(("aom_wind_rush_loop_high"), {
                gain = 0.1,
                object = self.object,
                max_hear_distance = 20,
                pitch = 1.5,
            })
        end
        aom_combat.projectile.on_step(self, dtime, {})
    end,
    _prj_can_collide = function(self, pointed_thing)
        if pointed_thing.type == "node" then
            local node = core.get_node(pointed_thing.under)
            local def = core.registered_nodes[node.name]
            if def and def.walkable then
                return true
            end
        else
            return true
        end
    end,
    _prj_on_collide = function(self, pointed_thing)
        core.sound_play(("aom_stone_step"), {
            gain = 6,
            pos = self.object:get_pos(),
            max_hear_distance = 30,
            pitch = 0.8,
        })
        if pointed_thing.type == "node" then
            self.object:set_velocity(vector.new(0,0,0))
        elseif (not self._prj_skip_objects) and pointed_thing.ref and (pointed_thing.ref ~= self._prj_owner) then
            local target = pointed_thing.ref
            send_attack(self._prj_owner or self.object, target, self._prj_damage_groups)
            self.object:set_velocity(vector.new(0,0,0))
            self._prj_skip_objects = true
        end
        self.object:remove()
        return true
    end,
    -- on_punch = function(self)
    --     self.object:remove()
    -- end,
    on_activate = function(self, staticdata, dtime_s)
        local data = core.deserialize(staticdata)
        if data then
            for key, val in pairs(data) do
                self[key] = val
            end
            if data._rotation then
                self.object:set_rotation(data._rotation)
            end
        end
        self._aom_particle_id = core.add_particlespawner({
            amount = 100,
            time = 0,
            attached = self.object,
            node = {name = "aom_stone:cobble_moss_1"},
            minsize = 0.2,
            maxsize = 3,
            minexptime = 0.1,
            maxexptime = 0.2,
        })
        self._aom_sound_id = core.sound_play(("aom_wind_rush_loop"), {
            gain = 0.1,
            object = self.object,
            max_hear_distance = 20,
            pitch = 1.5,
        })
    end,
    get_staticdata = function(self)
        local data = {}
        for i, key in pairs(self._aom_staticdata_load_list) do
            if key and self[key] ~= nil then
                data[key] = self[key]
            end
        end
        data._age = self._age
        data.vel = self.object:get_velocity()
        return core.serialize(data)
    end,
    on_deactivate = function(self, removal)
        if self._aom_sound_id then
            core.sound_fade(self._aom_sound_id, 3, 0)
        end
    end,
    _aom_staticdata_load_list = {
        "_age",
        "_rotation",
        "_prj_dir",
    },
    _age = 0,
    _prj_gravity = 9 * 1.6,
    _prj_damage_groups = table.copy(damage_groups),
    _prj_do_collision_checks = true,
})

