local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)


local tiles = {{name = "aom_lights_torch.png",
    backface_culling = false,
    animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.5}
}}

core.register_node("aom_lights:torch", {
    -- TL: static node light source
    description = S("Torch"),
    light_source = 12,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "aom_torch.b3d",
    use_texture_alpha = "clip",
    tiles = tiles,
    walkable = false,
    floodable = true,
    -- node_placement_prediction = "", -- turns off client predict node placement
    groups = { dig_immediate = 3, deco_block = 1, furniture = 1,
        player_place_only = 1, item_burns = 1, torch = 1, attached_node = 0, },
    sounds = aom_sounds.default_wood(),
    -- paramtype2 = "facedir",
	selection_box = {
		type = "fixed",
		fixed = {-3/16, -8/16, -3/16, 3/16, 0/16, 3/16},
	},
    on_place = function(itemstack, placer, pointed_thing)
        local ret = aom_util.try_rightclick(itemstack, placer, pointed_thing, false)
        if ret then
            return ret, nil
        end
        itemstack = ItemStack(itemstack)
        local ndef = itemstack:get_definition()
        local tmpstack = ItemStack(itemstack)
        local dir = vector.subtract(pointed_thing.under, pointed_thing.above)
        -- if it's placed on a wall, place the wall node instead
        if dir.y == 0 then
            tmpstack:set_name(ndef._wall)
        end
        local newstack, retpos = aom_util.rotate_and_place_against(
            tmpstack, placer, pointed_thing,
            {can_place = aom_lights.can_place, no_rightclick = true})
        -- then set the stack back to the original node
        if newstack then
            newstack:set_name(itemstack:get_name())
            if retpos then
                aom_lights.fix_wall_floor_placement(retpos, nil, false)
            end
            return newstack, retpos
        else
            return itemstack
        end
    end,
    node_placement_prediction = "air",
    _on_node_update = aom_lights.on_node_update,
    _wall = "aom_lights:torch_wall",
    _floor = "aom_lights:torch",
})

core.register_node("aom_lights:torch_wall", {
    description = S("Torch"),
    light_source = 12,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "aom_torch_wall.b3d",
    use_texture_alpha = "clip",
    tiles = tiles,
    drop = "aom_lights:torch",
    walkable = false,
    floodable = true,
    groups = { dig_immediate = 3, deco_block = 1, furniture = 1, torch = 1,
        not_in_creative_inventory = 1, attached_node = 0, },
    sounds = aom_sounds.default_wood(),
    paramtype2 = "facedir",
	selection_box = {
		type = "fixed",
		fixed = {-3/16, -6/16, 4/16, 3/16, 3/16, 8/16},
	},
    on_place = function(itemstack, placer, pointed_thing)
        return core.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true,})
    end,
    _on_node_update = aom_lights.on_node_update,
    _wall = "aom_lights:torch_wall",
    _floor = "aom_lights:torch",
})

if core.get_modpath("aom_tcraft") then
    aom_tcraft.register_group_craft({
        output = "aom_lights:torch 4",
        items = {
            ["aom_items:stick"] = 4
        },
        group = "coal",
        group_count = 1
    })
end
