local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

aom_spawnnodes = {}

-- dofile(mod_path .. "/.lua")

aom_spawnnodes.node_box = {
	type = "fixed",
	fixed = {
		-0.5, -0.5+0.01, -0.5,
		 0.5, -0.5+0.02,  0.5,
	}
}

function aom_spawnnodes.get_tiles(t)
	local tf = table.copy(t)
	tf.name = tf.name .. "^[transformFY"
	return {
		t, tf, "blank.png"
	}
end

local defaults = {
	drawtype = "nodebox",
	node_box = aom_spawnnodes.node_box,
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	groups = { nature = 1, spawnnode = 1, dig_immediate = 3, attached_node = 3 },
	use_texture_alpha = "clip",
	buildable_to = true,
	floodable = true,
	sounds = aom_sounds.default_topsoil(),
}

function aom_spawnnodes.register_node(n, t)
	local def = table.copy(t)
	def.groups = def.groups or {}
	for gn, gv in pairs(defaults.groups or {}) do
		def.groups[gn] = gv
	end
	for k, v in pairs(defaults or {}) do
		if def[k] == nil then
			def[k] = v
		end
	end
	core.register_node(n, def)
end

-- NODES

aom_spawnnodes.register_node("aom_spawnnodes:concerning_clover", {
	description = S("Concerning Clover"),
	tiles = aom_spawnnodes.get_tiles({
		name = "aom_spawnnodes_concerning_clover.png",
		align_style = "world", scale = 4,
	}),
})

aom_spawnnodes.register_node("aom_spawnnodes:freshly_dug_holes", {
	description = S("Freshly Dug Holes"),
	tiles = aom_spawnnodes.get_tiles({
		name = "aom_spawnnodes_freshly_dug_holes.png",
		align_style = "world", scale = 8,
	}),
})

aom_spawnnodes.register_node("aom_spawnnodes:mossy_rubble", {
	description = S("Mossy Rubble"),
	tiles = aom_spawnnodes.get_tiles({
		name = "aom_spawnnodes_mossy_rubble.png",
		align_style = "world", scale = 2,
	}),
	sounds = aom_sounds.default_stone(),
})

aom_spawnnodes.register_node("aom_spawnnodes:burning_ash", {
	description = S("Burning Ash"),
	tiles = aom_spawnnodes.get_tiles({
		name = "aom_spawnnodes_burning_ash.png",
		align_style = "world", scale = 2,
	}),
	light_source = 6,
	sounds = aom_sounds.default_stone(),
})

-- SPAWNRULES

function aom_spawnnodes.common_spawnrules(self, pos)
	return (
		(not aom_mob_spawn.has_player_in_range(pos, 0, 30)) and
		(aom_entity_api.has_mobs_in_radius(pos, self.nearby_range or 80, self.mobs, 0, (self.nearby_max or 3)))
	)
end

aom_mob_spawn.register_spawnnode("aom_spawnnodes:concerning_clover", {
	mobs = {"aom_goblins:goblin"},
	can_spawn = aom_spawnnodes.common_spawnrules,
})

aom_mob_spawn.register_spawnnode("aom_spawnnodes:freshly_dug_holes", {
	mobs = {"aom_animals:pipslug"},
	can_spawn = aom_spawnnodes.common_spawnrules,
})

aom_mob_spawn.register_spawnnode("aom_spawnnodes:mossy_rubble", {
	mobs = {"aom_kelar:kelar"},
	can_spawn = aom_spawnnodes.common_spawnrules,
})

aom_mob_spawn.register_spawnnode("aom_spawnnodes:burning_ash", {
	mobs = {"aom_kelar:kelar_underworld", "aom_elementals:magma"},
	can_spawn = aom_spawnnodes.common_spawnrules,
})

-- DECORATIONS

local sealevel = aom_vars.overworld.sea_level
local alt_max = aom_vars.overworld.alt_max
local alt_min = aom_vars.overworld.alt_min
core.register_decoration({
	deco_type = "simple",
	place_on = {
        "aom_stone:cobble_moss_1", "aom_stone:cobble_moss_2",
        "aom_stone:stone", "aom_stone:cobble",
    },
	sidelen = 4,
	noise_params = {
		offset = -0.2,
		scale = 0.5,
		spread = {x = 24, y = 8, z = 24},
		seed = 8567,
		octaves = 3,
		persist = 0.2,
		lacunarity = 2.00,
	},
	biomes = {"default"},
	y_max = alt_max,
	y_min = alt_min,
	decoration = "aom_spawnnodes:mossy_rubble",
    flags = "all_floors",
    _layer = 47,
})
