local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

aom_stone = {}

aom_stone.has_aom_tcraft = core.get_modpath("aom_tcraft") ~= nil
function aom_stone.register_craft(...)
	if aom_stone.has_aom_tcraft then
		return aom_tcraft.register_craft(...)
	end
end

function aom_stone.register_two_way_craft(a, b, c)
    if not c then c = 1 end
    aom_stone.register_craft({
        output = b .. " " .. c, items = {[a] = c},
    })
    aom_stone.register_craft({
        output = a .. " " .. c, items = {[b] = c}, hide_if_not_craftable = true,
    })
end

function aom_stone.register_transmute(a, b, n, c)
    local ig = "aom_items:ignis"
    aom_stone.register_craft({
        output = b .. " " .. n, items = {[a] = n, [ig] = c},
        tags = {"transmute"},
    })
    aom_stone.register_craft({
        output = a .. " " .. n, items = {[b] = n, [ig] = c},
        hide_if_not_craftable = true, tags = {"transmute"},
    })
end

dofile(mod_path .. "/stone.lua")
dofile(mod_path .. "/loose_stone.lua")
dofile(mod_path .. "/stone_bricks.lua")
dofile(mod_path .. "/obsidian_bricks.lua")
dofile(mod_path .. "/limestone_bricks.lua")
dofile(mod_path .. "/sandstone_bricks.lua")
dofile(mod_path .. "/granite_bricks.lua")
dofile(mod_path .. "/ironstone_bricks.lua")
