local mod_name = core.get_current_modname()
local mod_path = core.get_modpath(mod_name)
local S = core.get_translator(mod_name)

local pl = {}

local function get_shell()
    return {
        name = "",
        node = {name="air"},
    }
end

local function get_eyepos(player)
    local eyepos = vector.add(player:get_pos(), vector.multiply(player:get_eye_offset(), 0.1))
    eyepos.y = eyepos.y + player:get_properties().eye_height
    return eyepos
end

local get_tool_range = function (itemstack)
    return 20
end

local function get_pointed_thing(player, eyepos, liquids)
    if not eyepos then eyepos = get_eyepos(player) end
    local range = get_tool_range(player:get_wielded_item())
    local ray = core.raycast(eyepos, vector.add(eyepos, vector.multiply(player:get_look_dir(), range)), false, (liquids == true))
    for pointed_thing in ray do
        if pointed_thing.type == "node" then
            return pointed_thing
        end
    end
    return
end

local function send_message(player, color, message)
    core.chat_send_player(player:get_player_name(),
    "[paint tool] "..core.colorize(color, message))
end


local function paint(itemstack, player)
    if not pl[player] then pl[player] = get_shell() end
    if not pl[player] then return end

    local eyepos = get_eyepos(player)
    local pointed_thing = get_pointed_thing(player, eyepos)
    local pi = player:get_player_control()
    if not pointed_thing then return end
    local ppos = pointed_thing.under
    if pi and pi.aux1 then ppos = pointed_thing.above end
    -- allow player to fill solid blocks too when pressing aux1
    if pointed_thing and pi and pi.dig then
        if core.get_node(pointed_thing.under).name == pl[player].node.name then return end
        if pi.aux1 then
            core.set_node(pointed_thing.above, pl[player].node)
        else
            core.set_node(pointed_thing.under, pl[player].node)
        end
    end
end

core.register_tool("aom_admin_tools:paint", {
    description = S("Paint tool"),
    _tt_color = "#f0f",
    _tt_how_to_use = S("[place] to select a node") .. "\n" ..
        S("[dig] to paint the node you're looking at.").."\n"..
        S("Hold [aux1] to paint \"above\" the pointed position."),
    inventory_image = "aom_admin_tools_paint.png",
    wield_image = "aom_admin_tools_paint.png",
    wield_scale = {x=0.5, y=0.5, z=1},
    groups = { admin_tools = 1, not_in_creative_inventory = 1 },
    range = 100,
    on_secondary_use = function(itemstack, player)
        if not core.is_player(player) then return end
        if not pl[player] then pl[player] = get_shell() end
        pl[player].node = {name="air"}
        send_message(player, "#6af", "selection set to ".. "air")
        return itemstack
    end,
    on_place = function(itemstack, player, pointed_thing)
        if not core.is_player(player) then return end
        core.sound_play(("aom_admin_tools_click"), {
            gain = 0.1,
            pitch = 0.8,
            object = player,
        })
        if not pl[player] then pl[player] = get_shell() end
        pl[player].node = table.copy(core.get_node(pointed_thing.under))
        send_message(player, "#f7f", "selection set to "..pl[player].node.name)
        return itemstack
    end,
    on_use = function (itemstack, player, pointed_thing)
        if not core.is_player(player) then return end
        return paint(itemstack, player)
    end,
    _on_step = function(itemstack, player, dtime)
        return paint(itemstack, player)
    end,
    _on_deselect = function(itemstack, player)
    end,
})

if aom_admin_tools.has_aom_kits then
    aom_kits.add_to_kit("admin", {"aom_admin_tools:paint"})
end
