
aom_cooking.node_sounds = {}
local node_sounds = aom_cooking.node_sounds

function aom_cooking.do_node_sound(pos, sound_name)
    local index = tostring(pos)
    if (not node_sounds[index]) or node_sounds[index].timer < 0 then
        node_sounds[index] = {handle = 0, timer = 10}
        local sound
        local node = core.get_node(pos)
        local def = core.registered_nodes[node.name]
        if def._custom_sounds then
            sound = def._custom_sounds[sound_name or "passive"]
        end
        if not sound then return end
        local name = sound.name or ""
        sound = table.copy(sound)
        sound.pos = pos

        node_sounds[index].handle = core.sound_play(name, sound)
    end
end
function aom_cooking.stop_node_sound(pos)
    local index = tostring(pos)
    if node_sounds[index]
    and node_sounds[index].handle then
        core.sound_stop(node_sounds[index].handle)
    end
    node_sounds[index] = nil
end

function aom_cooking.node_sound_step(dtime)
    for index, sound in pairs(node_sounds) do
        sound.timer = sound.timer - dtime
        if sound.timer < 0 then
            core.sound_stop(node_sounds[index].handle)
            node_sounds[index] = nil
        end
    end
end

core.register_globalstep(aom_cooking.node_sound_step)
