local mod_name = core.get_current_modname()
local S = core.get_translator(mod_name)

core.register_node("aom_fengold:gilded_stone_brick", {
    description = S("Gilded Stone"),
    _tt_color = 2,
    groups = { nature = 1, material_gilded_stone = 1, full_solid = 1, gilded = 1,
               stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_fengold_stone_brick_gold.png",
    },
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_fengold:gilded_stone_brick")

core.register_craft({
    output = "aom_fengold:gilded_stone_brick",
    type = "shapeless",
    recipe = { "aom_stone:stone_brick", "aom_fengold:gold_gilding"},
})




core.register_node("aom_fengold:gilded_stone_brick_ornate", {
    description = S("Gilded Stone Ornate"),
    _tt_color = 2,
    groups = { nature = 1, material_gilded_stone = 1, full_solid = 1, gilded = 1,
               stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_fengold_stone_ornate_gold_top.png",
        "aom_fengold_stone_ornate_gold_top.png",
        "aom_fengold_stone_ornate_gold.png",
    },
    sounds = aom_sounds.default_stone(),
})
aom_util.register_all_shapes("aom_fengold:gilded_stone_brick_ornate", nil, {no_world_align = true})
aom_fengold.register_two_way_craft("aom_fengold:gilded_stone_brick", "aom_fengold:gilded_stone_brick_ornate")

core.register_node("aom_fengold:gilded_stone_pillar", {
    description = S("Gilded Stone Pillar"),
    _tt_color = 2,
    groups = { nature = 1, material_gilded_stone = 1, full_solid = 1, gilded = 1,
               stone = 1, oddly_breakable_by_hand = 3, cracky = 2, solid = 1, suffocates = 2 },
    tiles = {
        "aom_fengold_stone_pillar_gold_top.png",
        "aom_fengold_stone_pillar_gold_top.png",
        "aom_fengold_stone_pillar_gold.png",
    },
    sounds = aom_sounds.default_stone(),
    paramtype2 = "facedir",
    on_place = aom_util.rotate_and_place,
})
aom_util.register_all_shapes("aom_fengold:gilded_stone_pillar", nil, {no_world_align = true})
aom_fengold.register_two_way_craft("aom_fengold:gilded_stone_brick", "aom_fengold:gilded_stone_pillar")
